<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getL1HandoverInformationResponseAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U response description for the method "getL1HandoverInformation".
 * @subpackage Structs
 */
class GetL1HandoverInformationResponseAlau extends ResultType
{
    /**
     * The subscriptionEndPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subscriptionEndPointId;
    /**
     * The l1HandoverObject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1HandoverObjectType[]
     */
    public $l1HandoverObject;
    /**
     * Constructor method for getL1HandoverInformationResponseAlau
     * @uses GetL1HandoverInformationResponseAlau::setSubscriptionEndPointId()
     * @uses GetL1HandoverInformationResponseAlau::setL1HandoverObject()
     * @param string $subscriptionEndPointId
     * @param \StructType\L1HandoverObjectType[] $l1HandoverObject
     */
    public function __construct($subscriptionEndPointId = null, array $l1HandoverObject = array())
    {
        $this
            ->setSubscriptionEndPointId($subscriptionEndPointId)
            ->setL1HandoverObject($l1HandoverObject);
    }
    /**
     * Get subscriptionEndPointId value
     * @return string
     */
    public function getSubscriptionEndPointId()
    {
        return $this->subscriptionEndPointId;
    }
    /**
     * Set subscriptionEndPointId value
     * @param string $subscriptionEndPointId
     * @return \StructType\GetL1HandoverInformationResponseAlau
     */
    public function setSubscriptionEndPointId($subscriptionEndPointId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionEndPointId) && !is_string($subscriptionEndPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionEndPointId, true), gettype($subscriptionEndPointId)), __LINE__);
        }
        $this->subscriptionEndPointId = $subscriptionEndPointId;
        return $this;
    }
    /**
     * Get l1HandoverObject value
     * @return \StructType\L1HandoverObjectType[]|null
     */
    public function getL1HandoverObject()
    {
        return $this->l1HandoverObject;
    }
    /**
     * This method is responsible for validating the values passed to the setL1HandoverObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setL1HandoverObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateL1HandoverObjectForArrayConstraintsFromSetL1HandoverObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getL1HandoverInformationResponseAlauL1HandoverObjectItem) {
            // validation for constraint: itemType
            if (!$getL1HandoverInformationResponseAlauL1HandoverObjectItem instanceof \StructType\L1HandoverObjectType) {
                $invalidValues[] = is_object($getL1HandoverInformationResponseAlauL1HandoverObjectItem) ? get_class($getL1HandoverInformationResponseAlauL1HandoverObjectItem) : sprintf('%s(%s)', gettype($getL1HandoverInformationResponseAlauL1HandoverObjectItem), var_export($getL1HandoverInformationResponseAlauL1HandoverObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The l1HandoverObject property can only contain items of type \StructType\L1HandoverObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set l1HandoverObject value
     * @throws \InvalidArgumentException
     * @param \StructType\L1HandoverObjectType[] $l1HandoverObject
     * @return \StructType\GetL1HandoverInformationResponseAlau
     */
    public function setL1HandoverObject(array $l1HandoverObject = array())
    {
        // validation for constraint: array
        if ('' !== ($l1HandoverObjectArrayErrorMessage = self::validateL1HandoverObjectForArrayConstraintsFromSetL1HandoverObject($l1HandoverObject))) {
            throw new \InvalidArgumentException($l1HandoverObjectArrayErrorMessage, __LINE__);
        }
        $this->l1HandoverObject = $l1HandoverObject;
        return $this;
    }
    /**
     * Add item to l1HandoverObject value
     * @throws \InvalidArgumentException
     * @param \StructType\L1HandoverObjectType $item
     * @return \StructType\GetL1HandoverInformationResponseAlau
     */
    public function addToL1HandoverObject(\StructType\L1HandoverObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\L1HandoverObjectType) {
            throw new \InvalidArgumentException(sprintf('The l1HandoverObject property can only contain items of type \StructType\L1HandoverObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->l1HandoverObject[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetL1HandoverInformationResponseAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
