<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBOCChangeInformationRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "getBOCChangeInformation".
 * @subpackage Structs
 */
class GetBOCChangeInformationRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * The bocChangeOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\BOCChangeSearchPatternType
     */
    public $bocChangeOrder;
    /**
     * Constructor method for getBOCChangeInformationRequestAlau
     * @uses GetBOCChangeInformationRequestAlau::setAuthentication()
     * @uses GetBOCChangeInformationRequestAlau::setFocus()
     * @uses GetBOCChangeInformationRequestAlau::setBocChangeOrder()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\AlexBusinessFocusType $focus
     * @param \StructType\BOCChangeSearchPatternType $bocChangeOrder
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\AlexBusinessFocusType $focus = null, \StructType\BOCChangeSearchPatternType $bocChangeOrder = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setFocus($focus)
            ->setBocChangeOrder($bocChangeOrder);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\GetBOCChangeInformationRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\GetBOCChangeInformationRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Get bocChangeOrder value
     * @return \StructType\BOCChangeSearchPatternType|null
     */
    public function getBocChangeOrder()
    {
        return $this->bocChangeOrder;
    }
    /**
     * Set bocChangeOrder value
     * @param \StructType\BOCChangeSearchPatternType $bocChangeOrder
     * @return \StructType\GetBOCChangeInformationRequestAlau
     */
    public function setBocChangeOrder(\StructType\BOCChangeSearchPatternType $bocChangeOrder = null)
    {
        $this->bocChangeOrder = $bocChangeOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBOCChangeInformationRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
