<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getBOCChangeInformationRequestAlap StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-P request description for the method "getBOCChangeInformation".
 * @subpackage Structs
 */
class GetBOCChangeInformationRequestAlap extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusTypeAlap
     */
    public $focus;
    /**
     * The bocChangeOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\BOCChangeSearchPatternType
     */
    public $bocChangeOrder;
    /**
     * Constructor method for getBOCChangeInformationRequestAlap
     * @uses GetBOCChangeInformationRequestAlap::setAuthentication()
     * @uses GetBOCChangeInformationRequestAlap::setFocus()
     * @uses GetBOCChangeInformationRequestAlap::setBocChangeOrder()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @param \StructType\BOCChangeSearchPatternType $bocChangeOrder
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\AlexBusinessFocusTypeAlap $focus = null, \StructType\BOCChangeSearchPatternType $bocChangeOrder = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setFocus($focus)
            ->setBocChangeOrder($bocChangeOrder);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\GetBOCChangeInformationRequestAlap
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusTypeAlap|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @return \StructType\GetBOCChangeInformationRequestAlap
     */
    public function setFocus(\StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Get bocChangeOrder value
     * @return \StructType\BOCChangeSearchPatternType|null
     */
    public function getBocChangeOrder()
    {
        return $this->bocChangeOrder;
    }
    /**
     * Set bocChangeOrder value
     * @param \StructType\BOCChangeSearchPatternType $bocChangeOrder
     * @return \StructType\GetBOCChangeInformationRequestAlap
     */
    public function setBocChangeOrder(\StructType\BOCChangeSearchPatternType $bocChangeOrder = null)
    {
        $this->bocChangeOrder = $bocChangeOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetBOCChangeInformationRequestAlap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
