<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiberConnectionType StructType
 * Meta information extracted from the WSDL
 * - documentation: OTO-ID and plug number.
 * @subpackage Structs
 */
class FiberConnectionType extends AbstractStructBase
{
    /**
     * The otoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $otoId;
    /**
     * The plugNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $plugNr;
    /**
     * Constructor method for FiberConnectionType
     * @uses FiberConnectionType::setOtoId()
     * @uses FiberConnectionType::setPlugNr()
     * @param string $otoId
     * @param int $plugNr
     */
    public function __construct($otoId = null, $plugNr = null)
    {
        $this
            ->setOtoId($otoId)
            ->setPlugNr($plugNr);
    }
    /**
     * Get otoId value
     * @return string|null
     */
    public function getOtoId()
    {
        return $this->otoId;
    }
    /**
     * Set otoId value
     * @param string $otoId
     * @return \StructType\FiberConnectionType
     */
    public function setOtoId($otoId = null)
    {
        // validation for constraint: string
        if (!is_null($otoId) && !is_string($otoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otoId, true), gettype($otoId)), __LINE__);
        }
        $this->otoId = $otoId;
        return $this;
    }
    /**
     * Get plugNr value
     * @return int|null
     */
    public function getPlugNr()
    {
        return $this->plugNr;
    }
    /**
     * Set plugNr value
     * @param int $plugNr
     * @return \StructType\FiberConnectionType
     */
    public function setPlugNr($plugNr = null)
    {
        // validation for constraint: int
        if (!is_null($plugNr) && !(is_int($plugNr) || ctype_digit($plugNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($plugNr, true), gettype($plugNr)), __LINE__);
        }
        $this->plugNr = $plugNr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FiberConnectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
