<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateTicketType StructType
 * @subpackage Structs
 */
class CreateTicketType extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\ContactType
     */
    public $contact;
    /**
     * The tExternalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tExternalReference;
    /**
     * The tType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tType;
    /**
     * The tSeverity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tSeverity;
    /**
     * The tSubject
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tSubject;
    /**
     * The tDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tDescription;
    /**
     * The subscriptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionId;
    /**
     * The subscriptionEndPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionEndPointType
     */
    public $subscriptionEndPoint;
    /**
     * The breakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $breakout;
    /**
     * Constructor method for CreateTicketType
     * @uses CreateTicketType::setContact()
     * @uses CreateTicketType::setTExternalReference()
     * @uses CreateTicketType::setTType()
     * @uses CreateTicketType::setTSeverity()
     * @uses CreateTicketType::setTSubject()
     * @uses CreateTicketType::setTDescription()
     * @uses CreateTicketType::setSubscriptionId()
     * @uses CreateTicketType::setSubscriptionEndPoint()
     * @uses CreateTicketType::setBreakout()
     * @param \StructType\ContactType $contact
     * @param string $tExternalReference
     * @param string $tType
     * @param string $tSeverity
     * @param string $tSubject
     * @param string $tDescription
     * @param string $subscriptionId
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @param \StructType\L1BreakoutType $breakout
     */
    public function __construct(\StructType\ContactType $contact = null, $tExternalReference = null, $tType = null, $tSeverity = null, $tSubject = null, $tDescription = null, $subscriptionId = null, \StructType\SubscriptionEndPointType $subscriptionEndPoint = null, \StructType\L1BreakoutType $breakout = null)
    {
        $this
            ->setContact($contact)
            ->setTExternalReference($tExternalReference)
            ->setTType($tType)
            ->setTSeverity($tSeverity)
            ->setTSubject($tSubject)
            ->setTDescription($tDescription)
            ->setSubscriptionId($subscriptionId)
            ->setSubscriptionEndPoint($subscriptionEndPoint)
            ->setBreakout($breakout);
    }
    /**
     * Get contact value
     * @return \StructType\ContactType
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\ContactType $contact
     * @return \StructType\CreateTicketType
     */
    public function setContact(\StructType\ContactType $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get tExternalReference value
     * @return string|null
     */
    public function getTExternalReference()
    {
        return $this->tExternalReference;
    }
    /**
     * Set tExternalReference value
     * @param string $tExternalReference
     * @return \StructType\CreateTicketType
     */
    public function setTExternalReference($tExternalReference = null)
    {
        // validation for constraint: string
        if (!is_null($tExternalReference) && !is_string($tExternalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tExternalReference, true), gettype($tExternalReference)), __LINE__);
        }
        $this->tExternalReference = $tExternalReference;
        return $this;
    }
    /**
     * Get tType value
     * @return string|null
     */
    public function getTType()
    {
        return $this->tType;
    }
    /**
     * Set tType value
     * @uses \EnumType\TType::valueIsValid()
     * @uses \EnumType\TType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tType
     * @return \StructType\CreateTicketType
     */
    public function setTType($tType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TType::valueIsValid($tType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TType', is_array($tType) ? implode(', ', $tType) : var_export($tType, true), implode(', ', \EnumType\TType::getValidValues())), __LINE__);
        }
        $this->tType = $tType;
        return $this;
    }
    /**
     * Get tSeverity value
     * @return string|null
     */
    public function getTSeverity()
    {
        return $this->tSeverity;
    }
    /**
     * Set tSeverity value
     * @uses \EnumType\TSeverity::valueIsValid()
     * @uses \EnumType\TSeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tSeverity
     * @return \StructType\CreateTicketType
     */
    public function setTSeverity($tSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TSeverity::valueIsValid($tSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TSeverity', is_array($tSeverity) ? implode(', ', $tSeverity) : var_export($tSeverity, true), implode(', ', \EnumType\TSeverity::getValidValues())), __LINE__);
        }
        $this->tSeverity = $tSeverity;
        return $this;
    }
    /**
     * Get tSubject value
     * @return string|null
     */
    public function getTSubject()
    {
        return $this->tSubject;
    }
    /**
     * Set tSubject value
     * @param string $tSubject
     * @return \StructType\CreateTicketType
     */
    public function setTSubject($tSubject = null)
    {
        // validation for constraint: string
        if (!is_null($tSubject) && !is_string($tSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tSubject, true), gettype($tSubject)), __LINE__);
        }
        $this->tSubject = $tSubject;
        return $this;
    }
    /**
     * Get tDescription value
     * @return string|null
     */
    public function getTDescription()
    {
        return $this->tDescription;
    }
    /**
     * Set tDescription value
     * @param string $tDescription
     * @return \StructType\CreateTicketType
     */
    public function setTDescription($tDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tDescription) && !is_string($tDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tDescription, true), gettype($tDescription)), __LINE__);
        }
        $this->tDescription = $tDescription;
        return $this;
    }
    /**
     * Get subscriptionId value
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->subscriptionId;
    }
    /**
     * Set subscriptionId value
     * @param string $subscriptionId
     * @return \StructType\CreateTicketType
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        $this->subscriptionId = $subscriptionId;
        return $this;
    }
    /**
     * Get subscriptionEndPoint value
     * @return \StructType\SubscriptionEndPointType|null
     */
    public function getSubscriptionEndPoint()
    {
        return $this->subscriptionEndPoint;
    }
    /**
     * Set subscriptionEndPoint value
     * @param \StructType\SubscriptionEndPointType $subscriptionEndPoint
     * @return \StructType\CreateTicketType
     */
    public function setSubscriptionEndPoint(\StructType\SubscriptionEndPointType $subscriptionEndPoint = null)
    {
        $this->subscriptionEndPoint = $subscriptionEndPoint;
        return $this;
    }
    /**
     * Get breakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getBreakout()
    {
        return $this->breakout;
    }
    /**
     * Set breakout value
     * @param \StructType\L1BreakoutType $breakout
     * @return \StructType\CreateTicketType
     */
    public function setBreakout(\StructType\L1BreakoutType $breakout = null)
    {
        $this->breakout = $breakout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateTicketType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
