<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createTicketRequestAlap StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-P request description for the method "createTicket".
 * @subpackage Structs
 */
class CreateTicketRequestAlap extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The createTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\CreateTicketType
     */
    public $createTicket;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusTypeAlap
     */
    public $focus;
    /**
     * Constructor method for createTicketRequestAlap
     * @uses CreateTicketRequestAlap::setAuthentication()
     * @uses CreateTicketRequestAlap::setCreateTicket()
     * @uses CreateTicketRequestAlap::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\CreateTicketType $createTicket
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\CreateTicketType $createTicket = null, \StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setCreateTicket($createTicket)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\CreateTicketRequestAlap
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get createTicket value
     * @return \StructType\CreateTicketType
     */
    public function getCreateTicket()
    {
        return $this->createTicket;
    }
    /**
     * Set createTicket value
     * @param \StructType\CreateTicketType $createTicket
     * @return \StructType\CreateTicketRequestAlap
     */
    public function setCreateTicket(\StructType\CreateTicketType $createTicket = null)
    {
        $this->createTicket = $createTicket;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusTypeAlap|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @return \StructType\CreateTicketRequestAlap
     */
    public function setFocus(\StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateTicketRequestAlap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
