<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for closeTicketRequestAlap StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-P request description for the method "closeTicket".
 * @subpackage Structs
 */
class CloseTicketRequestAlap extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The closeTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\CloseTicketType
     */
    public $closeTicket;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusTypeAlap
     */
    public $focus;
    /**
     * Constructor method for closeTicketRequestAlap
     * @uses CloseTicketRequestAlap::setAuthentication()
     * @uses CloseTicketRequestAlap::setCloseTicket()
     * @uses CloseTicketRequestAlap::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\CloseTicketType $closeTicket
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\CloseTicketType $closeTicket = null, \StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setCloseTicket($closeTicket)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\CloseTicketRequestAlap
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get closeTicket value
     * @return \StructType\CloseTicketType
     */
    public function getCloseTicket()
    {
        return $this->closeTicket;
    }
    /**
     * Set closeTicket value
     * @param \StructType\CloseTicketType $closeTicket
     * @return \StructType\CloseTicketRequestAlap
     */
    public function setCloseTicket(\StructType\CloseTicketType $closeTicket = null)
    {
        $this->closeTicket = $closeTicket;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusTypeAlap|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @return \StructType\CloseTicketRequestAlap
     */
    public function setFocus(\StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CloseTicketRequestAlap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
