<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BOCChangeType StructType
 * @subpackage Structs
 */
class BOCChangeType extends AbstractStructBase
{
    /**
     * The bocChangeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bocChangeId;
    /**
     * The bocChangeIdTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bocChangeIdTo;
    /**
     * The externalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $externalReference;
    /**
     * The subscriptionEndPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionEndPointId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $status;
    /**
     * The wishdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $wishdate;
    /**
     * The switchdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $switchdate;
    /**
     * The switchdateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $switchdateTo;
    /**
     * The sfSLA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sfSLA;
    /**
     * The oldBreakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $oldBreakout;
    /**
     * The newBreakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $newBreakout;
    /**
     * The BOCChangeLog
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\BOCChangeLogType
     */
    public $BOCChangeLog;
    /**
     * The lastModification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lastModification;
    /**
     * The lastModificationTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lastModificationTo;
    /**
     * Constructor method for BOCChangeType
     * @uses BOCChangeType::setBocChangeId()
     * @uses BOCChangeType::setBocChangeIdTo()
     * @uses BOCChangeType::setExternalReference()
     * @uses BOCChangeType::setSubscriptionEndPointId()
     * @uses BOCChangeType::setStatus()
     * @uses BOCChangeType::setWishdate()
     * @uses BOCChangeType::setSwitchdate()
     * @uses BOCChangeType::setSwitchdateTo()
     * @uses BOCChangeType::setSfSLA()
     * @uses BOCChangeType::setOldBreakout()
     * @uses BOCChangeType::setNewBreakout()
     * @uses BOCChangeType::setBOCChangeLog()
     * @uses BOCChangeType::setLastModification()
     * @uses BOCChangeType::setLastModificationTo()
     * @param string $bocChangeId
     * @param string $bocChangeIdTo
     * @param string $externalReference
     * @param string $subscriptionEndPointId
     * @param string $status
     * @param string $wishdate
     * @param string $switchdate
     * @param string $switchdateTo
     * @param string $sfSLA
     * @param \StructType\L1BreakoutType $oldBreakout
     * @param \StructType\L1BreakoutType $newBreakout
     * @param \StructType\BOCChangeLogType $bOCChangeLog
     * @param string $lastModification
     * @param string $lastModificationTo
     */
    public function __construct($bocChangeId = null, $bocChangeIdTo = null, $externalReference = null, $subscriptionEndPointId = null, $status = null, $wishdate = null, $switchdate = null, $switchdateTo = null, $sfSLA = null, \StructType\L1BreakoutType $oldBreakout = null, \StructType\L1BreakoutType $newBreakout = null, \StructType\BOCChangeLogType $bOCChangeLog = null, $lastModification = null, $lastModificationTo = null)
    {
        $this
            ->setBocChangeId($bocChangeId)
            ->setBocChangeIdTo($bocChangeIdTo)
            ->setExternalReference($externalReference)
            ->setSubscriptionEndPointId($subscriptionEndPointId)
            ->setStatus($status)
            ->setWishdate($wishdate)
            ->setSwitchdate($switchdate)
            ->setSwitchdateTo($switchdateTo)
            ->setSfSLA($sfSLA)
            ->setOldBreakout($oldBreakout)
            ->setNewBreakout($newBreakout)
            ->setBOCChangeLog($bOCChangeLog)
            ->setLastModification($lastModification)
            ->setLastModificationTo($lastModificationTo);
    }
    /**
     * Get bocChangeId value
     * @return string|null
     */
    public function getBocChangeId()
    {
        return $this->bocChangeId;
    }
    /**
     * Set bocChangeId value
     * @param string $bocChangeId
     * @return \StructType\BOCChangeType
     */
    public function setBocChangeId($bocChangeId = null)
    {
        // validation for constraint: string
        if (!is_null($bocChangeId) && !is_string($bocChangeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bocChangeId, true), gettype($bocChangeId)), __LINE__);
        }
        $this->bocChangeId = $bocChangeId;
        return $this;
    }
    /**
     * Get bocChangeIdTo value
     * @return string|null
     */
    public function getBocChangeIdTo()
    {
        return $this->bocChangeIdTo;
    }
    /**
     * Set bocChangeIdTo value
     * @param string $bocChangeIdTo
     * @return \StructType\BOCChangeType
     */
    public function setBocChangeIdTo($bocChangeIdTo = null)
    {
        // validation for constraint: string
        if (!is_null($bocChangeIdTo) && !is_string($bocChangeIdTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bocChangeIdTo, true), gettype($bocChangeIdTo)), __LINE__);
        }
        $this->bocChangeIdTo = $bocChangeIdTo;
        return $this;
    }
    /**
     * Get externalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->externalReference;
    }
    /**
     * Set externalReference value
     * @param string $externalReference
     * @return \StructType\BOCChangeType
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        $this->externalReference = $externalReference;
        return $this;
    }
    /**
     * Get subscriptionEndPointId value
     * @return string|null
     */
    public function getSubscriptionEndPointId()
    {
        return $this->subscriptionEndPointId;
    }
    /**
     * Set subscriptionEndPointId value
     * @param string $subscriptionEndPointId
     * @return \StructType\BOCChangeType
     */
    public function setSubscriptionEndPointId($subscriptionEndPointId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionEndPointId) && !is_string($subscriptionEndPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionEndPointId, true), gettype($subscriptionEndPointId)), __LINE__);
        }
        $this->subscriptionEndPointId = $subscriptionEndPointId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\BocChangeStatus::valueIsValid()
     * @uses \EnumType\BocChangeStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BOCChangeType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BocChangeStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BocChangeStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\BocChangeStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get wishdate value
     * @return string|null
     */
    public function getWishdate()
    {
        return $this->wishdate;
    }
    /**
     * Set wishdate value
     * @param string $wishdate
     * @return \StructType\BOCChangeType
     */
    public function setWishdate($wishdate = null)
    {
        // validation for constraint: string
        if (!is_null($wishdate) && !is_string($wishdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wishdate, true), gettype($wishdate)), __LINE__);
        }
        $this->wishdate = $wishdate;
        return $this;
    }
    /**
     * Get switchdate value
     * @return string|null
     */
    public function getSwitchdate()
    {
        return $this->switchdate;
    }
    /**
     * Set switchdate value
     * @param string $switchdate
     * @return \StructType\BOCChangeType
     */
    public function setSwitchdate($switchdate = null)
    {
        // validation for constraint: string
        if (!is_null($switchdate) && !is_string($switchdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($switchdate, true), gettype($switchdate)), __LINE__);
        }
        $this->switchdate = $switchdate;
        return $this;
    }
    /**
     * Get switchdateTo value
     * @return string|null
     */
    public function getSwitchdateTo()
    {
        return $this->switchdateTo;
    }
    /**
     * Set switchdateTo value
     * @param string $switchdateTo
     * @return \StructType\BOCChangeType
     */
    public function setSwitchdateTo($switchdateTo = null)
    {
        // validation for constraint: string
        if (!is_null($switchdateTo) && !is_string($switchdateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($switchdateTo, true), gettype($switchdateTo)), __LINE__);
        }
        $this->switchdateTo = $switchdateTo;
        return $this;
    }
    /**
     * Get sfSLA value
     * @return string|null
     */
    public function getSfSLA()
    {
        return $this->sfSLA;
    }
    /**
     * Set sfSLA value
     * @uses \EnumType\SfSla::valueIsValid()
     * @uses \EnumType\SfSla::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sfSLA
     * @return \StructType\BOCChangeType
     */
    public function setSfSLA($sfSLA = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SfSla::valueIsValid($sfSLA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SfSla', is_array($sfSLA) ? implode(', ', $sfSLA) : var_export($sfSLA, true), implode(', ', \EnumType\SfSla::getValidValues())), __LINE__);
        }
        $this->sfSLA = $sfSLA;
        return $this;
    }
    /**
     * Get oldBreakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getOldBreakout()
    {
        return $this->oldBreakout;
    }
    /**
     * Set oldBreakout value
     * @param \StructType\L1BreakoutType $oldBreakout
     * @return \StructType\BOCChangeType
     */
    public function setOldBreakout(\StructType\L1BreakoutType $oldBreakout = null)
    {
        $this->oldBreakout = $oldBreakout;
        return $this;
    }
    /**
     * Get newBreakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getNewBreakout()
    {
        return $this->newBreakout;
    }
    /**
     * Set newBreakout value
     * @param \StructType\L1BreakoutType $newBreakout
     * @return \StructType\BOCChangeType
     */
    public function setNewBreakout(\StructType\L1BreakoutType $newBreakout = null)
    {
        $this->newBreakout = $newBreakout;
        return $this;
    }
    /**
     * Get BOCChangeLog value
     * @return \StructType\BOCChangeLogType|null
     */
    public function getBOCChangeLog()
    {
        return $this->BOCChangeLog;
    }
    /**
     * Set BOCChangeLog value
     * @param \StructType\BOCChangeLogType $bOCChangeLog
     * @return \StructType\BOCChangeType
     */
    public function setBOCChangeLog(\StructType\BOCChangeLogType $bOCChangeLog = null)
    {
        $this->BOCChangeLog = $bOCChangeLog;
        return $this;
    }
    /**
     * Get lastModification value
     * @return string|null
     */
    public function getLastModification()
    {
        return $this->lastModification;
    }
    /**
     * Set lastModification value
     * @param string $lastModification
     * @return \StructType\BOCChangeType
     */
    public function setLastModification($lastModification = null)
    {
        // validation for constraint: string
        if (!is_null($lastModification) && !is_string($lastModification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModification, true), gettype($lastModification)), __LINE__);
        }
        $this->lastModification = $lastModification;
        return $this;
    }
    /**
     * Get lastModificationTo value
     * @return string|null
     */
    public function getLastModificationTo()
    {
        return $this->lastModificationTo;
    }
    /**
     * Set lastModificationTo value
     * @param string $lastModificationTo
     * @return \StructType\BOCChangeType
     */
    public function setLastModificationTo($lastModificationTo = null)
    {
        // validation for constraint: string
        if (!is_null($lastModificationTo) && !is_string($lastModificationTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModificationTo, true), gettype($lastModificationTo)), __LINE__);
        }
        $this->lastModificationTo = $lastModificationTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BOCChangeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
