<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BOCChangeOrderType StructType
 * @subpackage Structs
 */
class BOCChangeOrderType extends AbstractStructBase
{
    /**
     * The bocChangeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bocChangeId;
    /**
     * The externalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $externalReference;
    /**
     * The subscriptionEndPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionEndPointId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $status;
    /**
     * The wishdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $wishdate;
    /**
     * The switchdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $switchdate;
    /**
     * The sfSLA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sfSLA;
    /**
     * The oldBreakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $oldBreakout;
    /**
     * The newBreakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $newBreakout;
    /**
     * The BOCChangeLog
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\BOCChangeLogType
     */
    public $BOCChangeLog;
    /**
     * Constructor method for BOCChangeOrderType
     * @uses BOCChangeOrderType::setBocChangeId()
     * @uses BOCChangeOrderType::setExternalReference()
     * @uses BOCChangeOrderType::setSubscriptionEndPointId()
     * @uses BOCChangeOrderType::setStatus()
     * @uses BOCChangeOrderType::setWishdate()
     * @uses BOCChangeOrderType::setSwitchdate()
     * @uses BOCChangeOrderType::setSfSLA()
     * @uses BOCChangeOrderType::setOldBreakout()
     * @uses BOCChangeOrderType::setNewBreakout()
     * @uses BOCChangeOrderType::setBOCChangeLog()
     * @param string $bocChangeId
     * @param string $externalReference
     * @param string $subscriptionEndPointId
     * @param string $status
     * @param string $wishdate
     * @param string $switchdate
     * @param string $sfSLA
     * @param \StructType\L1BreakoutType $oldBreakout
     * @param \StructType\L1BreakoutType $newBreakout
     * @param \StructType\BOCChangeLogType $bOCChangeLog
     */
    public function __construct($bocChangeId = null, $externalReference = null, $subscriptionEndPointId = null, $status = null, $wishdate = null, $switchdate = null, $sfSLA = null, \StructType\L1BreakoutType $oldBreakout = null, \StructType\L1BreakoutType $newBreakout = null, \StructType\BOCChangeLogType $bOCChangeLog = null)
    {
        $this
            ->setBocChangeId($bocChangeId)
            ->setExternalReference($externalReference)
            ->setSubscriptionEndPointId($subscriptionEndPointId)
            ->setStatus($status)
            ->setWishdate($wishdate)
            ->setSwitchdate($switchdate)
            ->setSfSLA($sfSLA)
            ->setOldBreakout($oldBreakout)
            ->setNewBreakout($newBreakout)
            ->setBOCChangeLog($bOCChangeLog);
    }
    /**
     * Get bocChangeId value
     * @return string|null
     */
    public function getBocChangeId()
    {
        return $this->bocChangeId;
    }
    /**
     * Set bocChangeId value
     * @param string $bocChangeId
     * @return \StructType\BOCChangeOrderType
     */
    public function setBocChangeId($bocChangeId = null)
    {
        // validation for constraint: string
        if (!is_null($bocChangeId) && !is_string($bocChangeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bocChangeId, true), gettype($bocChangeId)), __LINE__);
        }
        $this->bocChangeId = $bocChangeId;
        return $this;
    }
    /**
     * Get externalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->externalReference;
    }
    /**
     * Set externalReference value
     * @param string $externalReference
     * @return \StructType\BOCChangeOrderType
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        $this->externalReference = $externalReference;
        return $this;
    }
    /**
     * Get subscriptionEndPointId value
     * @return string|null
     */
    public function getSubscriptionEndPointId()
    {
        return $this->subscriptionEndPointId;
    }
    /**
     * Set subscriptionEndPointId value
     * @param string $subscriptionEndPointId
     * @return \StructType\BOCChangeOrderType
     */
    public function setSubscriptionEndPointId($subscriptionEndPointId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionEndPointId) && !is_string($subscriptionEndPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionEndPointId, true), gettype($subscriptionEndPointId)), __LINE__);
        }
        $this->subscriptionEndPointId = $subscriptionEndPointId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\BocChangeStatus::valueIsValid()
     * @uses \EnumType\BocChangeStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\BOCChangeOrderType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BocChangeStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BocChangeStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\BocChangeStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get wishdate value
     * @return string|null
     */
    public function getWishdate()
    {
        return $this->wishdate;
    }
    /**
     * Set wishdate value
     * @param string $wishdate
     * @return \StructType\BOCChangeOrderType
     */
    public function setWishdate($wishdate = null)
    {
        // validation for constraint: string
        if (!is_null($wishdate) && !is_string($wishdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wishdate, true), gettype($wishdate)), __LINE__);
        }
        $this->wishdate = $wishdate;
        return $this;
    }
    /**
     * Get switchdate value
     * @return string|null
     */
    public function getSwitchdate()
    {
        return $this->switchdate;
    }
    /**
     * Set switchdate value
     * @param string $switchdate
     * @return \StructType\BOCChangeOrderType
     */
    public function setSwitchdate($switchdate = null)
    {
        // validation for constraint: string
        if (!is_null($switchdate) && !is_string($switchdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($switchdate, true), gettype($switchdate)), __LINE__);
        }
        $this->switchdate = $switchdate;
        return $this;
    }
    /**
     * Get sfSLA value
     * @return string|null
     */
    public function getSfSLA()
    {
        return $this->sfSLA;
    }
    /**
     * Set sfSLA value
     * @uses \EnumType\SfSla::valueIsValid()
     * @uses \EnumType\SfSla::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sfSLA
     * @return \StructType\BOCChangeOrderType
     */
    public function setSfSLA($sfSLA = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SfSla::valueIsValid($sfSLA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SfSla', is_array($sfSLA) ? implode(', ', $sfSLA) : var_export($sfSLA, true), implode(', ', \EnumType\SfSla::getValidValues())), __LINE__);
        }
        $this->sfSLA = $sfSLA;
        return $this;
    }
    /**
     * Get oldBreakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getOldBreakout()
    {
        return $this->oldBreakout;
    }
    /**
     * Set oldBreakout value
     * @param \StructType\L1BreakoutType $oldBreakout
     * @return \StructType\BOCChangeOrderType
     */
    public function setOldBreakout(\StructType\L1BreakoutType $oldBreakout = null)
    {
        $this->oldBreakout = $oldBreakout;
        return $this;
    }
    /**
     * Get newBreakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getNewBreakout()
    {
        return $this->newBreakout;
    }
    /**
     * Set newBreakout value
     * @param \StructType\L1BreakoutType $newBreakout
     * @return \StructType\BOCChangeOrderType
     */
    public function setNewBreakout(\StructType\L1BreakoutType $newBreakout = null)
    {
        $this->newBreakout = $newBreakout;
        return $this;
    }
    /**
     * Get BOCChangeLog value
     * @return \StructType\BOCChangeLogType|null
     */
    public function getBOCChangeLog()
    {
        return $this->BOCChangeLog;
    }
    /**
     * Set BOCChangeLog value
     * @param \StructType\BOCChangeLogType $bOCChangeLog
     * @return \StructType\BOCChangeOrderType
     */
    public function setBOCChangeLog(\StructType\BOCChangeLogType $bOCChangeLog = null)
    {
        $this->BOCChangeLog = $bOCChangeLog;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BOCChangeOrderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
