<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlexBusinessFocusTypeAlap StructType
 * @subpackage Structs
 */
class AlexBusinessFocusTypeAlap extends AbstractStructBase
{
    /**
     * The alaProviderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $alaProviderId;
    /**
     * The serviceDomainId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $serviceDomainId;
    /**
     * The businessDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $businessDomain;
    /**
     * Constructor method for AlexBusinessFocusTypeAlap
     * @uses AlexBusinessFocusTypeAlap::setAlaProviderId()
     * @uses AlexBusinessFocusTypeAlap::setServiceDomainId()
     * @uses AlexBusinessFocusTypeAlap::setBusinessDomain()
     * @param int $alaProviderId
     * @param int $serviceDomainId
     * @param string $businessDomain
     */
    public function __construct($alaProviderId = null, $serviceDomainId = null, $businessDomain = null)
    {
        $this
            ->setAlaProviderId($alaProviderId)
            ->setServiceDomainId($serviceDomainId)
            ->setBusinessDomain($businessDomain);
    }
    /**
     * Get alaProviderId value
     * @return int|null
     */
    public function getAlaProviderId()
    {
        return $this->alaProviderId;
    }
    /**
     * Set alaProviderId value
     * @param int $alaProviderId
     * @return \StructType\AlexBusinessFocusTypeAlap
     */
    public function setAlaProviderId($alaProviderId = null)
    {
        // validation for constraint: int
        if (!is_null($alaProviderId) && !(is_int($alaProviderId) || ctype_digit($alaProviderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alaProviderId, true), gettype($alaProviderId)), __LINE__);
        }
        $this->alaProviderId = $alaProviderId;
        return $this;
    }
    /**
     * Get serviceDomainId value
     * @return int|null
     */
    public function getServiceDomainId()
    {
        return $this->serviceDomainId;
    }
    /**
     * Set serviceDomainId value
     * @param int $serviceDomainId
     * @return \StructType\AlexBusinessFocusTypeAlap
     */
    public function setServiceDomainId($serviceDomainId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceDomainId) && !(is_int($serviceDomainId) || ctype_digit($serviceDomainId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceDomainId, true), gettype($serviceDomainId)), __LINE__);
        }
        $this->serviceDomainId = $serviceDomainId;
        return $this;
    }
    /**
     * Get businessDomain value
     * @return string|null
     */
    public function getBusinessDomain()
    {
        return $this->businessDomain;
    }
    /**
     * Set businessDomain value
     * @uses \EnumType\BusinessDomain::valueIsValid()
     * @uses \EnumType\BusinessDomain::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessDomain
     * @return \StructType\AlexBusinessFocusTypeAlap
     */
    public function setBusinessDomain($businessDomain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessDomain::valueIsValid($businessDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessDomain', is_array($businessDomain) ? implode(', ', $businessDomain) : var_export($businessDomain, true), implode(', ', \EnumType\BusinessDomain::getValidValues())), __LINE__);
        }
        $this->businessDomain = $businessDomain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlexBusinessFocusTypeAlap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
