<?php

namespace EnumType;

/**
 * This class stands for tStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: SUBMITTED, SUSPENDED, IN-PROGRESS, CANCELLED, REJECTED, SOLVED or CLOSED.
 * @subpackage Enumerations
 */
class TStatus
{
    /**
     * Constant for value 'SUBMITTED'
     * @return string 'SUBMITTED'
     */
    const VALUE_SUBMITTED = 'SUBMITTED';
    /**
     * Constant for value 'SUSPENDED'
     * @return string 'SUSPENDED'
     */
    const VALUE_SUSPENDED = 'SUSPENDED';
    /**
     * Constant for value 'IN-PROGRESS'
     * @return string 'IN-PROGRESS'
     */
    const VALUE_IN_PROGRESS = 'IN-PROGRESS';
    /**
     * Constant for value 'CANCELLED'
     * @return string 'CANCELLED'
     */
    const VALUE_CANCELLED = 'CANCELLED';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Constant for value 'SOLVED'
     * @return string 'SOLVED'
     */
    const VALUE_SOLVED = 'SOLVED';
    /**
     * Constant for value 'CLOSED'
     * @return string 'CLOSED'
     */
    const VALUE_CLOSED = 'CLOSED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUBMITTED
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_IN_PROGRESS
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_SOLVED
     * @uses self::VALUE_CLOSED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUBMITTED,
            self::VALUE_SUSPENDED,
            self::VALUE_IN_PROGRESS,
            self::VALUE_CANCELLED,
            self::VALUE_REJECTED,
            self::VALUE_SOLVED,
            self::VALUE_CLOSED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
