<?php

namespace EnumType;

/**
 * This class stands for sfSla EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: STANDARD or EXPRESS.
 * @subpackage Enumerations
 */
class SfSla
{
    /**
     * Constant for value 'STANDARD'
     * @return string 'STANDARD'
     */
    const VALUE_STANDARD = 'STANDARD';
    /**
     * Constant for value 'EXPRESS'
     * @return string 'EXPRESS'
     */
    const VALUE_EXPRESS = 'EXPRESS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_EXPRESS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_EXPRESS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
