<?php

namespace EnumType;

/**
 * This class stands for rolloutStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: BEPREADY, PLUGFREE, PLUGINUSE, SIDEWALKREADY, L2READY or UNDEFINED.
 * @subpackage Enumerations
 */
class RolloutStatus
{
    /**
     * Constant for value 'BEPREADY'
     * @return string 'BEPREADY'
     */
    const VALUE_BEPREADY = 'BEPREADY';
    /**
     * Constant for value 'PLUGFREE'
     * @return string 'PLUGFREE'
     */
    const VALUE_PLUGFREE = 'PLUGFREE';
    /**
     * Constant for value 'PLUGINUSE'
     * @return string 'PLUGINUSE'
     */
    const VALUE_PLUGINUSE = 'PLUGINUSE';
    /**
     * Constant for value 'SIDEWALKREADY'
     * @return string 'SIDEWALKREADY'
     */
    const VALUE_SIDEWALKREADY = 'SIDEWALKREADY';
    /**
     * Constant for value 'L2READY'
     * @return string 'L2READY'
     */
    const VALUE_L_2_READY = 'L2READY';
    /**
     * Constant for value 'UNDEFINED'
     * @return string 'UNDEFINED'
     */
    const VALUE_UNDEFINED = 'UNDEFINED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEPREADY
     * @uses self::VALUE_PLUGFREE
     * @uses self::VALUE_PLUGINUSE
     * @uses self::VALUE_SIDEWALKREADY
     * @uses self::VALUE_L_2_READY
     * @uses self::VALUE_UNDEFINED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEPREADY,
            self::VALUE_PLUGFREE,
            self::VALUE_PLUGINUSE,
            self::VALUE_SIDEWALKREADY,
            self::VALUE_L_2_READY,
            self::VALUE_UNDEFINED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
