<?php

namespace EnumType;

/**
 * This class stands for businessDomain EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: L1 and L2. L1: Layer 1, L2: Layer 2.
 * @subpackage Enumerations
 */
class BusinessDomain
{
    /**
     * Constant for value 'L1'
     * @return string 'L1'
     */
    const VALUE_L_1 = 'L1';
    /**
     * Constant for value 'L2'
     * @return string 'L2'
     */
    const VALUE_L_2 = 'L2';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_L_1
     * @uses self::VALUE_L_2
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_L_1,
            self::VALUE_L_2,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
