<?php

namespace EnumType;

/**
 * This class stands for bocChangeStatus EnumType
 * @subpackage Enumerations
 */
class BocChangeStatus
{
    /**
     * Constant for value 'NEW'
     * @return string 'NEW'
     */
    const VALUE_NEW = 'NEW';
    /**
     * Constant for value 'ACCEPTED'
     * @return string 'ACCEPTED'
     */
    const VALUE_ACCEPTED = 'ACCEPTED';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Constant for value 'COMPLETED'
     * @return string 'COMPLETED'
     */
    const VALUE_COMPLETED = 'COMPLETED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_COMPLETED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_ACCEPTED,
            self::VALUE_REJECTED,
            self::VALUE_COMPLETED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
