<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceDomainInformationType StructType
 * @subpackage Structs
 */
class ServiceDomainInformationType extends AbstractStructBase
{
    /**
     * The serviceDomainId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $serviceDomainId;
    /**
     * The serviceDomainName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceDomainName;
    /**
     * Constructor method for ServiceDomainInformationType
     * @uses ServiceDomainInformationType::setServiceDomainId()
     * @uses ServiceDomainInformationType::setServiceDomainName()
     * @param int $serviceDomainId
     * @param string $serviceDomainName
     */
    public function __construct($serviceDomainId = null, $serviceDomainName = null)
    {
        $this
            ->setServiceDomainId($serviceDomainId)
            ->setServiceDomainName($serviceDomainName);
    }
    /**
     * Get serviceDomainId value
     * @return int|null
     */
    public function getServiceDomainId()
    {
        return $this->serviceDomainId;
    }
    /**
     * Set serviceDomainId value
     * @param int $serviceDomainId
     * @return \StructType\ServiceDomainInformationType
     */
    public function setServiceDomainId($serviceDomainId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceDomainId) && !(is_int($serviceDomainId) || ctype_digit($serviceDomainId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceDomainId, true), gettype($serviceDomainId)), __LINE__);
        }
        $this->serviceDomainId = $serviceDomainId;
        return $this;
    }
    /**
     * Get serviceDomainName value
     * @return string|null
     */
    public function getServiceDomainName()
    {
        return $this->serviceDomainName;
    }
    /**
     * Set serviceDomainName value
     * @param string $serviceDomainName
     * @return \StructType\ServiceDomainInformationType
     */
    public function setServiceDomainName($serviceDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDomainName) && !is_string($serviceDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDomainName, true), gettype($serviceDomainName)), __LINE__);
        }
        $this->serviceDomainName = $serviceDomainName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceDomainInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
