<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SepResultType StructType
 * @subpackage Structs
 */
class SepResultType extends AbstractStructBase
{
    /**
     * The alapinfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ResultType
     */
    public $alapinfo;
    /**
     * The sep
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionEndPointType[]
     */
    public $sep;
    /**
     * Constructor method for SepResultType
     * @uses SepResultType::setAlapinfo()
     * @uses SepResultType::setSep()
     * @param \StructType\ResultType $alapinfo
     * @param \StructType\SubscriptionEndPointType[] $sep
     */
    public function __construct(\StructType\ResultType $alapinfo = null, array $sep = array())
    {
        $this
            ->setAlapinfo($alapinfo)
            ->setSep($sep);
    }
    /**
     * Get alapinfo value
     * @return \StructType\ResultType|null
     */
    public function getAlapinfo()
    {
        return $this->alapinfo;
    }
    /**
     * Set alapinfo value
     * @param \StructType\ResultType $alapinfo
     * @return \StructType\SepResultType
     */
    public function setAlapinfo(\StructType\ResultType $alapinfo = null)
    {
        $this->alapinfo = $alapinfo;
        return $this;
    }
    /**
     * Get sep value
     * @return \StructType\SubscriptionEndPointType[]|null
     */
    public function getSep()
    {
        return $this->sep;
    }
    /**
     * This method is responsible for validating the values passed to the setSep method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSep method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSepForArrayConstraintsFromSetSep(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sepResultTypeSepItem) {
            // validation for constraint: itemType
            if (!$sepResultTypeSepItem instanceof \StructType\SubscriptionEndPointType) {
                $invalidValues[] = is_object($sepResultTypeSepItem) ? get_class($sepResultTypeSepItem) : sprintf('%s(%s)', gettype($sepResultTypeSepItem), var_export($sepResultTypeSepItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sep property can only contain items of type \StructType\SubscriptionEndPointType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sep value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionEndPointType[] $sep
     * @return \StructType\SepResultType
     */
    public function setSep(array $sep = array())
    {
        // validation for constraint: array
        if ('' !== ($sepArrayErrorMessage = self::validateSepForArrayConstraintsFromSetSep($sep))) {
            throw new \InvalidArgumentException($sepArrayErrorMessage, __LINE__);
        }
        $this->sep = $sep;
        return $this;
    }
    /**
     * Add item to sep value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionEndPointType $item
     * @return \StructType\SepResultType
     */
    public function addToSep(\StructType\SubscriptionEndPointType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubscriptionEndPointType) {
            throw new \InvalidArgumentException(sprintf('The sep property can only contain items of type \StructType\SubscriptionEndPointType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sep[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SepResultType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
