<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for restartCpeRequestAlap StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-P request description for the method "restartCpeRequest".
 * @subpackage Structs
 */
class RestartCpeRequestAlap extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The fiberConnection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\FiberConnectionRequestType
     */
    public $fiberConnection;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusTypeAlap
     */
    public $focus;
    /**
     * Constructor method for restartCpeRequestAlap
     * @uses RestartCpeRequestAlap::setAuthentication()
     * @uses RestartCpeRequestAlap::setFiberConnection()
     * @uses RestartCpeRequestAlap::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\FiberConnectionRequestType $fiberConnection
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\FiberConnectionRequestType $fiberConnection = null, \StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setFiberConnection($fiberConnection)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\RestartCpeRequestAlap
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get fiberConnection value
     * @return \StructType\FiberConnectionRequestType
     */
    public function getFiberConnection()
    {
        return $this->fiberConnection;
    }
    /**
     * Set fiberConnection value
     * @param \StructType\FiberConnectionRequestType $fiberConnection
     * @return \StructType\RestartCpeRequestAlap
     */
    public function setFiberConnection(\StructType\FiberConnectionRequestType $fiberConnection = null)
    {
        $this->fiberConnection = $fiberConnection;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusTypeAlap|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @return \StructType\RestartCpeRequestAlap
     */
    public function setFocus(\StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestartCpeRequestAlap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
