<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageType StructType
 * Meta information extracted from the WSDL
 * - documentation: See document ALEX_Messages_Vxyz.xlsx for the detailed list of errors.
 * @subpackage Structs
 */
class MessageType extends AbstractStructBase
{
    /**
     * The occurenceDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $occurenceDateTime;
    /**
     * The messageNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $messageNo;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $message;
    /**
     * The messageDetailed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $messageDetailed;
    /**
     * Constructor method for MessageType
     * @uses MessageType::setOccurenceDateTime()
     * @uses MessageType::setMessageNo()
     * @uses MessageType::setMessage()
     * @uses MessageType::setMessageDetailed()
     * @param string $occurenceDateTime
     * @param string $messageNo
     * @param string $message
     * @param string $messageDetailed
     */
    public function __construct($occurenceDateTime = null, $messageNo = null, $message = null, $messageDetailed = null)
    {
        $this
            ->setOccurenceDateTime($occurenceDateTime)
            ->setMessageNo($messageNo)
            ->setMessage($message)
            ->setMessageDetailed($messageDetailed);
    }
    /**
     * Get occurenceDateTime value
     * @return string|null
     */
    public function getOccurenceDateTime()
    {
        return $this->occurenceDateTime;
    }
    /**
     * Set occurenceDateTime value
     * @param string $occurenceDateTime
     * @return \StructType\MessageType
     */
    public function setOccurenceDateTime($occurenceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($occurenceDateTime) && !is_string($occurenceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($occurenceDateTime, true), gettype($occurenceDateTime)), __LINE__);
        }
        $this->occurenceDateTime = $occurenceDateTime;
        return $this;
    }
    /**
     * Get messageNo value
     * @return string|null
     */
    public function getMessageNo()
    {
        return $this->messageNo;
    }
    /**
     * Set messageNo value
     * @param string $messageNo
     * @return \StructType\MessageType
     */
    public function setMessageNo($messageNo = null)
    {
        // validation for constraint: string
        if (!is_null($messageNo) && !is_string($messageNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageNo, true), gettype($messageNo)), __LINE__);
        }
        $this->messageNo = $messageNo;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\MessageType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get messageDetailed value
     * @return string|null
     */
    public function getMessageDetailed()
    {
        return $this->messageDetailed;
    }
    /**
     * Set messageDetailed value
     * @param string $messageDetailed
     * @return \StructType\MessageType
     */
    public function setMessageDetailed($messageDetailed = null)
    {
        // validation for constraint: string
        if (!is_null($messageDetailed) && !is_string($messageDetailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDetailed, true), gettype($messageDetailed)), __LINE__);
        }
        $this->messageDetailed = $messageDetailed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
