<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for L1HandoverObjectType StructType
 * @subpackage Structs
 */
class L1HandoverObjectType extends AbstractStructBase
{
    /**
     * The l1HandoverLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $l1HandoverLocation;
    /**
     * The l1HandoverType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $l1HandoverType;
    /**
     * The l1HandoverEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1HandoverEquipmentType
     */
    public $l1HandoverEquipment;
    /**
     * Constructor method for L1HandoverObjectType
     * @uses L1HandoverObjectType::setL1HandoverLocation()
     * @uses L1HandoverObjectType::setL1HandoverType()
     * @uses L1HandoverObjectType::setL1HandoverEquipment()
     * @param string $l1HandoverLocation
     * @param string $l1HandoverType
     * @param \StructType\L1HandoverEquipmentType $l1HandoverEquipment
     */
    public function __construct($l1HandoverLocation = null, $l1HandoverType = null, \StructType\L1HandoverEquipmentType $l1HandoverEquipment = null)
    {
        $this
            ->setL1HandoverLocation($l1HandoverLocation)
            ->setL1HandoverType($l1HandoverType)
            ->setL1HandoverEquipment($l1HandoverEquipment);
    }
    /**
     * Get l1HandoverLocation value
     * @return string
     */
    public function getL1HandoverLocation()
    {
        return $this->l1HandoverLocation;
    }
    /**
     * Set l1HandoverLocation value
     * @param string $l1HandoverLocation
     * @return \StructType\L1HandoverObjectType
     */
    public function setL1HandoverLocation($l1HandoverLocation = null)
    {
        // validation for constraint: string
        if (!is_null($l1HandoverLocation) && !is_string($l1HandoverLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($l1HandoverLocation, true), gettype($l1HandoverLocation)), __LINE__);
        }
        $this->l1HandoverLocation = $l1HandoverLocation;
        return $this;
    }
    /**
     * Get l1HandoverType value
     * @return string
     */
    public function getL1HandoverType()
    {
        return $this->l1HandoverType;
    }
    /**
     * Set l1HandoverType value
     * @uses \EnumType\HandoverType::valueIsValid()
     * @uses \EnumType\HandoverType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $l1HandoverType
     * @return \StructType\L1HandoverObjectType
     */
    public function setL1HandoverType($l1HandoverType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HandoverType::valueIsValid($l1HandoverType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\HandoverType', is_array($l1HandoverType) ? implode(', ', $l1HandoverType) : var_export($l1HandoverType, true), implode(', ', \EnumType\HandoverType::getValidValues())), __LINE__);
        }
        $this->l1HandoverType = $l1HandoverType;
        return $this;
    }
    /**
     * Get l1HandoverEquipment value
     * @return \StructType\L1HandoverEquipmentType|null
     */
    public function getL1HandoverEquipment()
    {
        return $this->l1HandoverEquipment;
    }
    /**
     * Set l1HandoverEquipment value
     * @param \StructType\L1HandoverEquipmentType $l1HandoverEquipment
     * @return \StructType\L1HandoverObjectType
     */
    public function setL1HandoverEquipment(\StructType\L1HandoverEquipmentType $l1HandoverEquipment = null)
    {
        $this->l1HandoverEquipment = $l1HandoverEquipment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\L1HandoverObjectType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
