<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getTicketRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "getTicket".
 * @subpackage Structs
 */
class GetTicketRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The getTicketSearchPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\TicketSearchPatternType
     */
    public $getTicketSearchPattern;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * Constructor method for getTicketRequestAlau
     * @uses GetTicketRequestAlau::setAuthentication()
     * @uses GetTicketRequestAlau::setGetTicketSearchPattern()
     * @uses GetTicketRequestAlau::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\TicketSearchPatternType $getTicketSearchPattern
     * @param \StructType\AlexBusinessFocusType $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\TicketSearchPatternType $getTicketSearchPattern = null, \StructType\AlexBusinessFocusType $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setGetTicketSearchPattern($getTicketSearchPattern)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\GetTicketRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get getTicketSearchPattern value
     * @return \StructType\TicketSearchPatternType
     */
    public function getGetTicketSearchPattern()
    {
        return $this->getTicketSearchPattern;
    }
    /**
     * Set getTicketSearchPattern value
     * @param \StructType\TicketSearchPatternType $getTicketSearchPattern
     * @return \StructType\GetTicketRequestAlau
     */
    public function setGetTicketSearchPattern(\StructType\TicketSearchPatternType $getTicketSearchPattern = null)
    {
        $this->getTicketSearchPattern = $getTicketSearchPattern;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\GetTicketRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetTicketRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
