<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSubscriptionEndPointInformationRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "getSubscriptionEndPointInformation".
 * @subpackage Structs
 */
class GetSubscriptionEndPointInformationRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The subscriptionEndPointSearchPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\SubscriptionEndPointSearchPatternType
     */
    public $subscriptionEndPointSearchPattern;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * Constructor method for getSubscriptionEndPointInformationRequestAlau
     * @uses GetSubscriptionEndPointInformationRequestAlau::setAuthentication()
     * @uses GetSubscriptionEndPointInformationRequestAlau::setSubscriptionEndPointSearchPattern()
     * @uses GetSubscriptionEndPointInformationRequestAlau::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern
     * @param \StructType\AlexBusinessFocusType $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern = null, \StructType\AlexBusinessFocusType $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setSubscriptionEndPointSearchPattern($subscriptionEndPointSearchPattern)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get subscriptionEndPointSearchPattern value
     * @return \StructType\SubscriptionEndPointSearchPatternType
     */
    public function getSubscriptionEndPointSearchPattern()
    {
        return $this->subscriptionEndPointSearchPattern;
    }
    /**
     * Set subscriptionEndPointSearchPattern value
     * @param \StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlau
     */
    public function setSubscriptionEndPointSearchPattern(\StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern = null)
    {
        $this->subscriptionEndPointSearchPattern = $subscriptionEndPointSearchPattern;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
