<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAlaProviderInformationResponseAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U response description for the method "getAlaProviderInformation".
 * @subpackage Structs
 */
class GetAlaProviderInformationResponseAlau extends ResultBasicType
{
    /**
     * The alap
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlaProviderInformationType[]
     */
    public $alap;
    /**
     * Constructor method for getAlaProviderInformationResponseAlau
     * @uses GetAlaProviderInformationResponseAlau::setAlap()
     * @param \StructType\AlaProviderInformationType[] $alap
     */
    public function __construct(array $alap = array())
    {
        $this
            ->setAlap($alap);
    }
    /**
     * Get alap value
     * @return \StructType\AlaProviderInformationType[]|null
     */
    public function getAlap()
    {
        return $this->alap;
    }
    /**
     * This method is responsible for validating the values passed to the setAlap method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlap method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlapForArrayConstraintsFromSetAlap(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getAlaProviderInformationResponseAlauAlapItem) {
            // validation for constraint: itemType
            if (!$getAlaProviderInformationResponseAlauAlapItem instanceof \StructType\AlaProviderInformationType) {
                $invalidValues[] = is_object($getAlaProviderInformationResponseAlauAlapItem) ? get_class($getAlaProviderInformationResponseAlauAlapItem) : sprintf('%s(%s)', gettype($getAlaProviderInformationResponseAlauAlapItem), var_export($getAlaProviderInformationResponseAlauAlapItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The alap property can only contain items of type \StructType\AlaProviderInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set alap value
     * @throws \InvalidArgumentException
     * @param \StructType\AlaProviderInformationType[] $alap
     * @return \StructType\GetAlaProviderInformationResponseAlau
     */
    public function setAlap(array $alap = array())
    {
        // validation for constraint: array
        if ('' !== ($alapArrayErrorMessage = self::validateAlapForArrayConstraintsFromSetAlap($alap))) {
            throw new \InvalidArgumentException($alapArrayErrorMessage, __LINE__);
        }
        $this->alap = $alap;
        return $this;
    }
    /**
     * Add item to alap value
     * @throws \InvalidArgumentException
     * @param \StructType\AlaProviderInformationType $item
     * @return \StructType\GetAlaProviderInformationResponseAlau
     */
    public function addToAlap(\StructType\AlaProviderInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AlaProviderInformationType) {
            throw new \InvalidArgumentException(sprintf('The alap property can only contain items of type \StructType\AlaProviderInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->alap[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAlaProviderInformationResponseAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
