<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAlaProviderInformationRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "getAlaProviderInformation".
 * @subpackage Structs
 */
class GetAlaProviderInformationRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * The alaProviderSearchPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlaProviderInformationType
     */
    public $alaProviderSearchPattern;
    /**
     * Constructor method for getAlaProviderInformationRequestAlau
     * @uses GetAlaProviderInformationRequestAlau::setAuthentication()
     * @uses GetAlaProviderInformationRequestAlau::setFocus()
     * @uses GetAlaProviderInformationRequestAlau::setAlaProviderSearchPattern()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\AlexBusinessFocusType $focus
     * @param \StructType\AlaProviderInformationType $alaProviderSearchPattern
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\AlexBusinessFocusType $focus = null, \StructType\AlaProviderInformationType $alaProviderSearchPattern = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setFocus($focus)
            ->setAlaProviderSearchPattern($alaProviderSearchPattern);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\GetAlaProviderInformationRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\GetAlaProviderInformationRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Get alaProviderSearchPattern value
     * @return \StructType\AlaProviderInformationType|null
     */
    public function getAlaProviderSearchPattern()
    {
        return $this->alaProviderSearchPattern;
    }
    /**
     * Set alaProviderSearchPattern value
     * @param \StructType\AlaProviderInformationType $alaProviderSearchPattern
     * @return \StructType\GetAlaProviderInformationRequestAlau
     */
    public function setAlaProviderSearchPattern(\StructType\AlaProviderInformationType $alaProviderSearchPattern = null)
    {
        $this->alaProviderSearchPattern = $alaProviderSearchPattern;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAlaProviderInformationRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
