<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateBOCChangeType StructType
 * @subpackage Structs
 */
class CreateBOCChangeType extends AbstractStructBase
{
    /**
     * The externalReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $externalReference;
    /**
     * The subscriptionEndPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriptionEndPointId;
    /**
     * The wishdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $wishdate;
    /**
     * The sfSLA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sfSLA;
    /**
     * The oldBreakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $oldBreakout;
    /**
     * The newBreakout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\L1BreakoutType
     */
    public $newBreakout;
    /**
     * Constructor method for CreateBOCChangeType
     * @uses CreateBOCChangeType::setExternalReference()
     * @uses CreateBOCChangeType::setSubscriptionEndPointId()
     * @uses CreateBOCChangeType::setWishdate()
     * @uses CreateBOCChangeType::setSfSLA()
     * @uses CreateBOCChangeType::setOldBreakout()
     * @uses CreateBOCChangeType::setNewBreakout()
     * @param string $externalReference
     * @param string $subscriptionEndPointId
     * @param string $wishdate
     * @param string $sfSLA
     * @param \StructType\L1BreakoutType $oldBreakout
     * @param \StructType\L1BreakoutType $newBreakout
     */
    public function __construct($externalReference = null, $subscriptionEndPointId = null, $wishdate = null, $sfSLA = null, \StructType\L1BreakoutType $oldBreakout = null, \StructType\L1BreakoutType $newBreakout = null)
    {
        $this
            ->setExternalReference($externalReference)
            ->setSubscriptionEndPointId($subscriptionEndPointId)
            ->setWishdate($wishdate)
            ->setSfSLA($sfSLA)
            ->setOldBreakout($oldBreakout)
            ->setNewBreakout($newBreakout);
    }
    /**
     * Get externalReference value
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->externalReference;
    }
    /**
     * Set externalReference value
     * @param string $externalReference
     * @return \StructType\CreateBOCChangeType
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        $this->externalReference = $externalReference;
        return $this;
    }
    /**
     * Get subscriptionEndPointId value
     * @return string|null
     */
    public function getSubscriptionEndPointId()
    {
        return $this->subscriptionEndPointId;
    }
    /**
     * Set subscriptionEndPointId value
     * @param string $subscriptionEndPointId
     * @return \StructType\CreateBOCChangeType
     */
    public function setSubscriptionEndPointId($subscriptionEndPointId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionEndPointId) && !is_string($subscriptionEndPointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionEndPointId, true), gettype($subscriptionEndPointId)), __LINE__);
        }
        $this->subscriptionEndPointId = $subscriptionEndPointId;
        return $this;
    }
    /**
     * Get wishdate value
     * @return string|null
     */
    public function getWishdate()
    {
        return $this->wishdate;
    }
    /**
     * Set wishdate value
     * @param string $wishdate
     * @return \StructType\CreateBOCChangeType
     */
    public function setWishdate($wishdate = null)
    {
        // validation for constraint: string
        if (!is_null($wishdate) && !is_string($wishdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wishdate, true), gettype($wishdate)), __LINE__);
        }
        $this->wishdate = $wishdate;
        return $this;
    }
    /**
     * Get sfSLA value
     * @return string|null
     */
    public function getSfSLA()
    {
        return $this->sfSLA;
    }
    /**
     * Set sfSLA value
     * @uses \EnumType\SfSla::valueIsValid()
     * @uses \EnumType\SfSla::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sfSLA
     * @return \StructType\CreateBOCChangeType
     */
    public function setSfSLA($sfSLA = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SfSla::valueIsValid($sfSLA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SfSla', is_array($sfSLA) ? implode(', ', $sfSLA) : var_export($sfSLA, true), implode(', ', \EnumType\SfSla::getValidValues())), __LINE__);
        }
        $this->sfSLA = $sfSLA;
        return $this;
    }
    /**
     * Get oldBreakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getOldBreakout()
    {
        return $this->oldBreakout;
    }
    /**
     * Set oldBreakout value
     * @param \StructType\L1BreakoutType $oldBreakout
     * @return \StructType\CreateBOCChangeType
     */
    public function setOldBreakout(\StructType\L1BreakoutType $oldBreakout = null)
    {
        $this->oldBreakout = $oldBreakout;
        return $this;
    }
    /**
     * Get newBreakout value
     * @return \StructType\L1BreakoutType|null
     */
    public function getNewBreakout()
    {
        return $this->newBreakout;
    }
    /**
     * Set newBreakout value
     * @param \StructType\L1BreakoutType $newBreakout
     * @return \StructType\CreateBOCChangeType
     */
    public function setNewBreakout(\StructType\L1BreakoutType $newBreakout = null)
    {
        $this->newBreakout = $newBreakout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateBOCChangeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
