<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CpeInformationType StructType
 * @subpackage Structs
 */
class CpeInformationType extends AbstractStructBase
{
    /**
     * The cpeStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cpeStatus;
    /**
     * The cpeMacAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cpeMacAddress;
    /**
     * The vlanCpeInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $vlanCpeInformation;
    /**
     * Constructor method for CpeInformationType
     * @uses CpeInformationType::setCpeStatus()
     * @uses CpeInformationType::setCpeMacAddress()
     * @uses CpeInformationType::setVlanCpeInformation()
     * @param string $cpeStatus
     * @param string $cpeMacAddress
     * @param string $vlanCpeInformation
     */
    public function __construct($cpeStatus = null, $cpeMacAddress = null, $vlanCpeInformation = null)
    {
        $this
            ->setCpeStatus($cpeStatus)
            ->setCpeMacAddress($cpeMacAddress)
            ->setVlanCpeInformation($vlanCpeInformation);
    }
    /**
     * Get cpeStatus value
     * @return string|null
     */
    public function getCpeStatus()
    {
        return $this->cpeStatus;
    }
    /**
     * Set cpeStatus value
     * @param string $cpeStatus
     * @return \StructType\CpeInformationType
     */
    public function setCpeStatus($cpeStatus = null)
    {
        // validation for constraint: string
        if (!is_null($cpeStatus) && !is_string($cpeStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpeStatus, true), gettype($cpeStatus)), __LINE__);
        }
        $this->cpeStatus = $cpeStatus;
        return $this;
    }
    /**
     * Get cpeMacAddress value
     * @return string|null
     */
    public function getCpeMacAddress()
    {
        return $this->cpeMacAddress;
    }
    /**
     * Set cpeMacAddress value
     * @param string $cpeMacAddress
     * @return \StructType\CpeInformationType
     */
    public function setCpeMacAddress($cpeMacAddress = null)
    {
        // validation for constraint: string
        if (!is_null($cpeMacAddress) && !is_string($cpeMacAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpeMacAddress, true), gettype($cpeMacAddress)), __LINE__);
        }
        $this->cpeMacAddress = $cpeMacAddress;
        return $this;
    }
    /**
     * Get vlanCpeInformation value
     * @return string|null
     */
    public function getVlanCpeInformation()
    {
        return $this->vlanCpeInformation;
    }
    /**
     * Set vlanCpeInformation value
     * @param string $vlanCpeInformation
     * @return \StructType\CpeInformationType
     */
    public function setVlanCpeInformation($vlanCpeInformation = null)
    {
        // validation for constraint: string
        if (!is_null($vlanCpeInformation) && !is_string($vlanCpeInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vlanCpeInformation, true), gettype($vlanCpeInformation)), __LINE__);
        }
        $this->vlanCpeInformation = $vlanCpeInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CpeInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
