<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Authentication in ALEX and ALAP backends.
 * @subpackage Structs
 */
class AuthenticationType extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The userInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userInformation;
    /**
     * Constructor method for AuthenticationType
     * @uses AuthenticationType::setUsername()
     * @uses AuthenticationType::setPassword()
     * @uses AuthenticationType::setUserInformation()
     * @param string $username
     * @param string $password
     * @param string $userInformation
     */
    public function __construct($username = null, $password = null, $userInformation = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setUserInformation($userInformation);
    }
    /**
     * Get username value
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\AuthenticationType
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\AuthenticationType
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get userInformation value
     * @return string|null
     */
    public function getUserInformation()
    {
        return $this->userInformation;
    }
    /**
     * Set userInformation value
     * @param string $userInformation
     * @return \StructType\AuthenticationType
     */
    public function setUserInformation($userInformation = null)
    {
        // validation for constraint: string
        if (!is_null($userInformation) && !is_string($userInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInformation, true), gettype($userInformation)), __LINE__);
        }
        $this->userInformation = $userInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthenticationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
