<?php

namespace EnumType;

/**
 * This class stands for tType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: Delegate, Assurance, Fulfillment or Info.
 * @subpackage Enumerations
 */
class TType
{
    /**
     * Constant for value 'Delegate'
     * @return string 'Delegate'
     */
    const VALUE_DELEGATE = 'Delegate';
    /**
     * Constant for value 'Assurance'
     * @return string 'Assurance'
     */
    const VALUE_ASSURANCE = 'Assurance';
    /**
     * Constant for value 'Fulfillment'
     * @return string 'Fulfillment'
     */
    const VALUE_FULFILLMENT = 'Fulfillment';
    /**
     * Constant for value 'Info'
     * @return string 'Info'
     */
    const VALUE_INFO = 'Info';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DELEGATE
     * @uses self::VALUE_ASSURANCE
     * @uses self::VALUE_FULFILLMENT
     * @uses self::VALUE_INFO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DELEGATE,
            self::VALUE_ASSURANCE,
            self::VALUE_FULFILLMENT,
            self::VALUE_INFO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
