<?php

namespace EnumType;

/**
 * This class stands for HandoverType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: OMDF, OHDF, XMDF or Other
 * @subpackage Enumerations
 */
class HandoverType
{
    /**
     * Constant for value 'OHDF'
     * @return string 'OHDF'
     */
    const VALUE_OHDF = 'OHDF';
    /**
     * Constant for value 'XMDF'
     * @return string 'XMDF'
     */
    const VALUE_XMDF = 'XMDF';
    /**
     * Constant for value 'OMDF'
     * @return string 'OMDF'
     */
    const VALUE_OMDF = 'OMDF';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OHDF
     * @uses self::VALUE_XMDF
     * @uses self::VALUE_OMDF
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OHDF,
            self::VALUE_XMDF,
            self::VALUE_OMDF,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
