<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionLogType StructType
 * @subpackage Structs
 */
class SubscriptionLogType extends AbstractStructBase
{
    /**
     * The subscriptionEvent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionEventType[]
     */
    public $subscriptionEvent;
    /**
     * Constructor method for SubscriptionLogType
     * @uses SubscriptionLogType::setSubscriptionEvent()
     * @param \StructType\SubscriptionEventType[] $subscriptionEvent
     */
    public function __construct(array $subscriptionEvent = array())
    {
        $this
            ->setSubscriptionEvent($subscriptionEvent);
    }
    /**
     * Get subscriptionEvent value
     * @return \StructType\SubscriptionEventType[]|null
     */
    public function getSubscriptionEvent()
    {
        return $this->subscriptionEvent;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscriptionEvent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscriptionEvent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionEventForArrayConstraintsFromSetSubscriptionEvent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subscriptionLogTypeSubscriptionEventItem) {
            // validation for constraint: itemType
            if (!$subscriptionLogTypeSubscriptionEventItem instanceof \StructType\SubscriptionEventType) {
                $invalidValues[] = is_object($subscriptionLogTypeSubscriptionEventItem) ? get_class($subscriptionLogTypeSubscriptionEventItem) : sprintf('%s(%s)', gettype($subscriptionLogTypeSubscriptionEventItem), var_export($subscriptionLogTypeSubscriptionEventItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The subscriptionEvent property can only contain items of type \StructType\SubscriptionEventType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set subscriptionEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionEventType[] $subscriptionEvent
     * @return \StructType\SubscriptionLogType
     */
    public function setSubscriptionEvent(array $subscriptionEvent = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionEventArrayErrorMessage = self::validateSubscriptionEventForArrayConstraintsFromSetSubscriptionEvent($subscriptionEvent))) {
            throw new \InvalidArgumentException($subscriptionEventArrayErrorMessage, __LINE__);
        }
        $this->subscriptionEvent = $subscriptionEvent;
        return $this;
    }
    /**
     * Add item to subscriptionEvent value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriptionEventType $item
     * @return \StructType\SubscriptionLogType
     */
    public function addToSubscriptionEvent(\StructType\SubscriptionEventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubscriptionEventType) {
            throw new \InvalidArgumentException(sprintf('The subscriptionEvent property can only contain items of type \StructType\SubscriptionEventType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->subscriptionEvent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriptionLogType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
