<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSubscriptionInformationRequestAlau StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-U request description for the method "getSubscriptionInformation".
 * @subpackage Structs
 */
class GetSubscriptionInformationRequestAlau extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusType
     */
    public $focus;
    /**
     * The subscriptionSearchPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\SubscriptionSearchPatternType
     */
    public $subscriptionSearchPattern;
    /**
     * Constructor method for getSubscriptionInformationRequestAlau
     * @uses GetSubscriptionInformationRequestAlau::setAuthentication()
     * @uses GetSubscriptionInformationRequestAlau::setFocus()
     * @uses GetSubscriptionInformationRequestAlau::setSubscriptionSearchPattern()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\AlexBusinessFocusType $focus
     * @param \StructType\SubscriptionSearchPatternType $subscriptionSearchPattern
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\AlexBusinessFocusType $focus = null, \StructType\SubscriptionSearchPatternType $subscriptionSearchPattern = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setFocus($focus)
            ->setSubscriptionSearchPattern($subscriptionSearchPattern);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\GetSubscriptionInformationRequestAlau
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusType|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusType $focus
     * @return \StructType\GetSubscriptionInformationRequestAlau
     */
    public function setFocus(\StructType\AlexBusinessFocusType $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Get subscriptionSearchPattern value
     * @return \StructType\SubscriptionSearchPatternType|null
     */
    public function getSubscriptionSearchPattern()
    {
        return $this->subscriptionSearchPattern;
    }
    /**
     * Set subscriptionSearchPattern value
     * @param \StructType\SubscriptionSearchPatternType $subscriptionSearchPattern
     * @return \StructType\GetSubscriptionInformationRequestAlau
     */
    public function setSubscriptionSearchPattern(\StructType\SubscriptionSearchPatternType $subscriptionSearchPattern = null)
    {
        $this->subscriptionSearchPattern = $subscriptionSearchPattern;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubscriptionInformationRequestAlau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
