<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSubscriptionEndPointInformationRequestAlap StructType
 * Meta information extracted from the WSDL
 * - documentation: ALA-P request description for the method "getSubscriptionEndPointInformation".
 * @subpackage Structs
 */
class GetSubscriptionEndPointInformationRequestAlap extends AbstractStructBase
{
    /**
     * The authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\AuthenticationType
     */
    public $authentication;
    /**
     * The subscriptionEndPointSearchPattern
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\SubscriptionEndPointSearchPatternType
     */
    public $subscriptionEndPointSearchPattern;
    /**
     * The focus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\AlexBusinessFocusTypeAlap
     */
    public $focus;
    /**
     * Constructor method for getSubscriptionEndPointInformationRequestAlap
     * @uses GetSubscriptionEndPointInformationRequestAlap::setAuthentication()
     * @uses GetSubscriptionEndPointInformationRequestAlap::setSubscriptionEndPointSearchPattern()
     * @uses GetSubscriptionEndPointInformationRequestAlap::setFocus()
     * @param \StructType\AuthenticationType $authentication
     * @param \StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     */
    public function __construct(\StructType\AuthenticationType $authentication = null, \StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern = null, \StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setSubscriptionEndPointSearchPattern($subscriptionEndPointSearchPattern)
            ->setFocus($focus);
    }
    /**
     * Get authentication value
     * @return \StructType\AuthenticationType
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \StructType\AuthenticationType $authentication
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlap
     */
    public function setAuthentication(\StructType\AuthenticationType $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get subscriptionEndPointSearchPattern value
     * @return \StructType\SubscriptionEndPointSearchPatternType
     */
    public function getSubscriptionEndPointSearchPattern()
    {
        return $this->subscriptionEndPointSearchPattern;
    }
    /**
     * Set subscriptionEndPointSearchPattern value
     * @param \StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlap
     */
    public function setSubscriptionEndPointSearchPattern(\StructType\SubscriptionEndPointSearchPatternType $subscriptionEndPointSearchPattern = null)
    {
        $this->subscriptionEndPointSearchPattern = $subscriptionEndPointSearchPattern;
        return $this;
    }
    /**
     * Get focus value
     * @return \StructType\AlexBusinessFocusTypeAlap|null
     */
    public function getFocus()
    {
        return $this->focus;
    }
    /**
     * Set focus value
     * @param \StructType\AlexBusinessFocusTypeAlap $focus
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlap
     */
    public function setFocus(\StructType\AlexBusinessFocusTypeAlap $focus = null)
    {
        $this->focus = $focus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubscriptionEndPointInformationRequestAlap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
