<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlaProviderInformationType StructType
 * @subpackage Structs
 */
class AlaProviderInformationType extends AbstractStructBase
{
    /**
     * The alaProviderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $alaProviderId;
    /**
     * The alaProviderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alaProviderName;
    /**
     * The businessDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $businessDomain;
    /**
     * The serviceDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\ServiceDomainInformationType[]
     */
    public $serviceDomain;
    /**
     * Constructor method for AlaProviderInformationType
     * @uses AlaProviderInformationType::setAlaProviderId()
     * @uses AlaProviderInformationType::setAlaProviderName()
     * @uses AlaProviderInformationType::setBusinessDomain()
     * @uses AlaProviderInformationType::setServiceDomain()
     * @param int $alaProviderId
     * @param string $alaProviderName
     * @param string $businessDomain
     * @param \StructType\ServiceDomainInformationType[] $serviceDomain
     */
    public function __construct($alaProviderId = null, $alaProviderName = null, $businessDomain = null, array $serviceDomain = array())
    {
        $this
            ->setAlaProviderId($alaProviderId)
            ->setAlaProviderName($alaProviderName)
            ->setBusinessDomain($businessDomain)
            ->setServiceDomain($serviceDomain);
    }
    /**
     * Get alaProviderId value
     * @return int|null
     */
    public function getAlaProviderId()
    {
        return $this->alaProviderId;
    }
    /**
     * Set alaProviderId value
     * @param int $alaProviderId
     * @return \StructType\AlaProviderInformationType
     */
    public function setAlaProviderId($alaProviderId = null)
    {
        // validation for constraint: int
        if (!is_null($alaProviderId) && !(is_int($alaProviderId) || ctype_digit($alaProviderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alaProviderId, true), gettype($alaProviderId)), __LINE__);
        }
        $this->alaProviderId = $alaProviderId;
        return $this;
    }
    /**
     * Get alaProviderName value
     * @return string|null
     */
    public function getAlaProviderName()
    {
        return $this->alaProviderName;
    }
    /**
     * Set alaProviderName value
     * @param string $alaProviderName
     * @return \StructType\AlaProviderInformationType
     */
    public function setAlaProviderName($alaProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($alaProviderName) && !is_string($alaProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alaProviderName, true), gettype($alaProviderName)), __LINE__);
        }
        $this->alaProviderName = $alaProviderName;
        return $this;
    }
    /**
     * Get businessDomain value
     * @return string|null
     */
    public function getBusinessDomain()
    {
        return $this->businessDomain;
    }
    /**
     * Set businessDomain value
     * @uses \EnumType\BusinessDomain::valueIsValid()
     * @uses \EnumType\BusinessDomain::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessDomain
     * @return \StructType\AlaProviderInformationType
     */
    public function setBusinessDomain($businessDomain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessDomain::valueIsValid($businessDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BusinessDomain', is_array($businessDomain) ? implode(', ', $businessDomain) : var_export($businessDomain, true), implode(', ', \EnumType\BusinessDomain::getValidValues())), __LINE__);
        }
        $this->businessDomain = $businessDomain;
        return $this;
    }
    /**
     * Get serviceDomain value
     * @return \StructType\ServiceDomainInformationType[]|null
     */
    public function getServiceDomain()
    {
        return $this->serviceDomain;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceDomain method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDomain method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceDomainForArrayConstraintsFromSetServiceDomain(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $alaProviderInformationTypeServiceDomainItem) {
            // validation for constraint: itemType
            if (!$alaProviderInformationTypeServiceDomainItem instanceof \StructType\ServiceDomainInformationType) {
                $invalidValues[] = is_object($alaProviderInformationTypeServiceDomainItem) ? get_class($alaProviderInformationTypeServiceDomainItem) : sprintf('%s(%s)', gettype($alaProviderInformationTypeServiceDomainItem), var_export($alaProviderInformationTypeServiceDomainItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The serviceDomain property can only contain items of type \StructType\ServiceDomainInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set serviceDomain value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceDomainInformationType[] $serviceDomain
     * @return \StructType\AlaProviderInformationType
     */
    public function setServiceDomain(array $serviceDomain = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceDomainArrayErrorMessage = self::validateServiceDomainForArrayConstraintsFromSetServiceDomain($serviceDomain))) {
            throw new \InvalidArgumentException($serviceDomainArrayErrorMessage, __LINE__);
        }
        $this->serviceDomain = $serviceDomain;
        return $this;
    }
    /**
     * Add item to serviceDomain value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceDomainInformationType $item
     * @return \StructType\AlaProviderInformationType
     */
    public function addToServiceDomain(\StructType\ServiceDomainInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceDomainInformationType) {
            throw new \InvalidArgumentException(sprintf('The serviceDomain property can only contain items of type \StructType\ServiceDomainInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->serviceDomain[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlaProviderInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
