<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named
     * getSubscriptionEndPointInformationAlap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSubscriptionEndPointInformationRequestAlap $parameters1
     * @return \StructType\GetSubscriptionEndPointInformationResponseAlap|bool
     */
    public function getSubscriptionEndPointInformationAlap(\StructType\GetSubscriptionEndPointInformationRequestAlap $parameters1)
    {
        try {
            $this->setResult($this->getSoapClient()->getSubscriptionEndPointInformationAlap($parameters1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAvailableServicesAlap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableServicesRequestAlap $parameters1
     * @return \StructType\GetAvailableServicesResponseAlap|bool
     */
    public function getAvailableServicesAlap(\StructType\GetAvailableServicesRequestAlap $parameters1)
    {
        try {
            $this->setResult($this->getSoapClient()->getAvailableServicesAlap($parameters1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAvailableServicesResponseAlap|\StructType\GetSubscriptionEndPointInformationResponseAlap
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
