<?php

namespace EnumType;

/**
 * This class stands for tSeverity EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: Critical, High, Medium or Low.
 * @subpackage Enumerations
 */
class TSeverity
{
    /**
     * Constant for value 'Critical'
     * @return string 'Critical'
     */
    const VALUE_CRITICAL = 'Critical';
    /**
     * Constant for value 'High'
     * @return string 'High'
     */
    const VALUE_HIGH = 'High';
    /**
     * Constant for value 'Medium'
     * @return string 'Medium'
     */
    const VALUE_MEDIUM = 'Medium';
    /**
     * Constant for value 'Low'
     * @return string 'Low'
     */
    const VALUE_LOW = 'Low';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CRITICAL
     * @uses self::VALUE_HIGH
     * @uses self::VALUE_MEDIUM
     * @uses self::VALUE_LOW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CRITICAL,
            self::VALUE_HIGH,
            self::VALUE_MEDIUM,
            self::VALUE_LOW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
