<?php

namespace EnumType;

/**
 * This class stands for status EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeration type (LOV). Possible values: NEW, ACCEPTED-O, REJECTED-O, COMMISSION, EXCEPTION-UC, EXCEPTION-PC, RUNNING, CEASE, ACCEPTED-C, REJECTED-C, DECOMMISSION, EXCEPTION-UD, EXCEPTION-PD, TERMINATED or DELETED.
 * @subpackage Enumerations
 */
class Status
{
    /**
     * Constant for value 'NEW'
     * @return string 'NEW'
     */
    const VALUE_NEW = 'NEW';
    /**
     * Constant for value 'ACCEPTED-O'
     * @return string 'ACCEPTED-O'
     */
    const VALUE_ACCEPTED_O = 'ACCEPTED-O';
    /**
     * Constant for value 'REJECTED-O'
     * @return string 'REJECTED-O'
     */
    const VALUE_REJECTED_O = 'REJECTED-O';
    /**
     * Constant for value 'COMMISSION'
     * @return string 'COMMISSION'
     */
    const VALUE_COMMISSION = 'COMMISSION';
    /**
     * Constant for value 'EXCEPTION-UC'
     * @return string 'EXCEPTION-UC'
     */
    const VALUE_EXCEPTION_UC = 'EXCEPTION-UC';
    /**
     * Constant for value 'EXCEPTION-PC'
     * @return string 'EXCEPTION-PC'
     */
    const VALUE_EXCEPTION_PC = 'EXCEPTION-PC';
    /**
     * Constant for value 'RUNNING'
     * @return string 'RUNNING'
     */
    const VALUE_RUNNING = 'RUNNING';
    /**
     * Constant for value 'CEASE'
     * @return string 'CEASE'
     */
    const VALUE_CEASE = 'CEASE';
    /**
     * Constant for value 'ACCEPTED-C'
     * @return string 'ACCEPTED-C'
     */
    const VALUE_ACCEPTED_C = 'ACCEPTED-C';
    /**
     * Constant for value 'REJECTED-C'
     * @return string 'REJECTED-C'
     */
    const VALUE_REJECTED_C = 'REJECTED-C';
    /**
     * Constant for value 'DECOMMISSION'
     * @return string 'DECOMMISSION'
     */
    const VALUE_DECOMMISSION = 'DECOMMISSION';
    /**
     * Constant for value 'EXCEPTION-UD'
     * @return string 'EXCEPTION-UD'
     */
    const VALUE_EXCEPTION_UD = 'EXCEPTION-UD';
    /**
     * Constant for value 'EXCEPTION-PD'
     * @return string 'EXCEPTION-PD'
     */
    const VALUE_EXCEPTION_PD = 'EXCEPTION-PD';
    /**
     * Constant for value 'TERMINATED'
     * @return string 'TERMINATED'
     */
    const VALUE_TERMINATED = 'TERMINATED';
    /**
     * Constant for value 'DELETED'
     * @return string 'DELETED'
     */
    const VALUE_DELETED = 'DELETED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_ACCEPTED_O
     * @uses self::VALUE_REJECTED_O
     * @uses self::VALUE_COMMISSION
     * @uses self::VALUE_EXCEPTION_UC
     * @uses self::VALUE_EXCEPTION_PC
     * @uses self::VALUE_RUNNING
     * @uses self::VALUE_CEASE
     * @uses self::VALUE_ACCEPTED_C
     * @uses self::VALUE_REJECTED_C
     * @uses self::VALUE_DECOMMISSION
     * @uses self::VALUE_EXCEPTION_UD
     * @uses self::VALUE_EXCEPTION_PD
     * @uses self::VALUE_TERMINATED
     * @uses self::VALUE_DELETED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_ACCEPTED_O,
            self::VALUE_REJECTED_O,
            self::VALUE_COMMISSION,
            self::VALUE_EXCEPTION_UC,
            self::VALUE_EXCEPTION_PC,
            self::VALUE_RUNNING,
            self::VALUE_CEASE,
            self::VALUE_ACCEPTED_C,
            self::VALUE_REJECTED_C,
            self::VALUE_DECOMMISSION,
            self::VALUE_EXCEPTION_UD,
            self::VALUE_EXCEPTION_PD,
            self::VALUE_TERMINATED,
            self::VALUE_DELETED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
