<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertPolicy $parameters
     * @return \StructType\InsertPolicyResponse|bool
     */
    public function InsertPolicy(\StructType\InsertPolicy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertPolicy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertPolicyNV
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertPolicyNV $parameters
     * @return \StructType\InsertPolicyNVResponse|bool
     */
    public function InsertPolicyNV(\StructType\InsertPolicyNV $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertPolicyNV($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsertPolicyNVResponse|\StructType\InsertPolicyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
