<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calcpremium ServiceType
 * @subpackage Services
 */
class Calcpremium extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named calc_premium
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Calc_premium $parameters
     * @return \StructType\Calc_premiumResponse|bool
     */
    public function calc_premium(\StructType\Calc_premium $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->calc_premium($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Calc_premiumResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
