<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for IsUserValid operation/method
 */
if ($is->IsUserValid(new \StructType\IsUserValid()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Calcpremium ServiceType
 */
$calcpremium = new \ServiceType\Calcpremium($options);
/**
 * Sample call for calc_premium operation/method
 */
if ($calcpremium->calc_premium(new \StructType\Calc_premium()) !== false) {
    print_r($calcpremium->getResult());
} else {
    print_r($calcpremium->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetRiskGoup operation/method
 */
if ($get->GetRiskGoup(new \StructType\GetRiskGoup()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPDF operation/method
 */
if ($get->GetPDF(new \StructType\GetPDF()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMileage operation/method
 */
if ($get->GetMileage(new \StructType\GetMileage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
/**
 * Sample call for ValidatePolicyXml operation/method
 */
if ($validate->ValidatePolicyXml(new \StructType\ValidatePolicyXml()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
/**
 * Sample call for InsertPolicy operation/method
 */
if ($insert->InsertPolicy(new \StructType\InsertPolicy()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertPolicyNV operation/method
 */
if ($insert->InsertPolicyNV(new \StructType\InsertPolicyNV()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckXsltSchema operation/method
 */
if ($check->CheckXsltSchema(new \StructType\CheckXsltSchema()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
/**
 * Sample call for GeneratePolicy operation/method
 */
if ($generate->GeneratePolicy(new \StructType\GeneratePolicy()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Attach ServiceType
 */
$attach = new \ServiceType\Attach($options);
/**
 * Sample call for AttachDocument operation/method
 */
if ($attach->AttachDocument(new \StructType\AttachDocument()) !== false) {
    print_r($attach->getResult());
} else {
    print_r($attach->getLastError());
}
