<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for verticalImpl StructType
 * @subpackage Structs
 */
class VerticalImpl extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The businessType
     * @var string
     */
    public $businessType;
    /**
     * Constructor method for verticalImpl
     * @uses VerticalImpl::setId()
     * @uses VerticalImpl::setName()
     * @uses VerticalImpl::setBusinessType()
     * @param string $id
     * @param string $name
     * @param string $businessType
     */
    public function __construct($id = null, $name = null, $businessType = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setBusinessType($businessType);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\VerticalImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\VerticalImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get businessType value
     * @return string|null
     */
    public function getBusinessType()
    {
        return $this->businessType;
    }
    /**
     * Set businessType value
     * @uses \EnumType\BusinessTypeEnum::valueIsValid()
     * @uses \EnumType\BusinessTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $businessType
     * @return \StructType\VerticalImpl
     */
    public function setBusinessType($businessType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BusinessTypeEnum::valueIsValid($businessType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $businessType, implode(', ', \EnumType\BusinessTypeEnum::getValidValues())), __LINE__);
        }
        $this->businessType = $businessType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerticalImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
