<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telephonyBulkPlanImpl StructType
 * @subpackage Structs
 */
class TelephonyBulkPlanImpl extends TelephonyBulkBaseImpl
{
    /**
     * The submarketId
     * @var string
     */
    public $submarketId;
    /**
     * The servicePlanOptions
     * @var \StructType\ServicePlanOptions
     */
    public $servicePlanOptions;
    /**
     * The rudicsGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rudicsGroup;
    /**
     * The twoStageVoice
     * @var \StructType\TwoStageImpl
     */
    public $twoStageVoice;
    /**
     * The twoStageData
     * @var \StructType\TwoStageImpl
     */
    public $twoStageData;
    /**
     * The enableLocalNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $enableLocalNumber;
    /**
     * The localCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localCountry;
    /**
     * Constructor method for telephonyBulkPlanImpl
     * @uses TelephonyBulkPlanImpl::setSubmarketId()
     * @uses TelephonyBulkPlanImpl::setServicePlanOptions()
     * @uses TelephonyBulkPlanImpl::setRudicsGroup()
     * @uses TelephonyBulkPlanImpl::setTwoStageVoice()
     * @uses TelephonyBulkPlanImpl::setTwoStageData()
     * @uses TelephonyBulkPlanImpl::setEnableLocalNumber()
     * @uses TelephonyBulkPlanImpl::setLocalCountry()
     * @param string $submarketId
     * @param \StructType\ServicePlanOptions $servicePlanOptions
     * @param string $rudicsGroup
     * @param \StructType\TwoStageImpl $twoStageVoice
     * @param \StructType\TwoStageImpl $twoStageData
     * @param string $enableLocalNumber
     * @param string $localCountry
     */
    public function __construct($submarketId = null, \StructType\ServicePlanOptions $servicePlanOptions = null, $rudicsGroup = null, \StructType\TwoStageImpl $twoStageVoice = null, \StructType\TwoStageImpl $twoStageData = null, $enableLocalNumber = null, $localCountry = null)
    {
        $this
            ->setSubmarketId($submarketId)
            ->setServicePlanOptions($servicePlanOptions)
            ->setRudicsGroup($rudicsGroup)
            ->setTwoStageVoice($twoStageVoice)
            ->setTwoStageData($twoStageData)
            ->setEnableLocalNumber($enableLocalNumber)
            ->setLocalCountry($localCountry);
    }
    /**
     * Get submarketId value
     * @return string|null
     */
    public function getSubmarketId()
    {
        return $this->submarketId;
    }
    /**
     * Set submarketId value
     * @param string $submarketId
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public function setSubmarketId($submarketId = null)
    {
        // validation for constraint: string
        if (!is_null($submarketId) && !is_string($submarketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketId)), __LINE__);
        }
        $this->submarketId = $submarketId;
        return $this;
    }
    /**
     * Get servicePlanOptions value
     * @return \StructType\ServicePlanOptions|null
     */
    public function getServicePlanOptions()
    {
        return $this->servicePlanOptions;
    }
    /**
     * Set servicePlanOptions value
     * @param \StructType\ServicePlanOptions $servicePlanOptions
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public function setServicePlanOptions(\StructType\ServicePlanOptions $servicePlanOptions = null)
    {
        $this->servicePlanOptions = $servicePlanOptions;
        return $this;
    }
    /**
     * Get rudicsGroup value
     * @return string|null
     */
    public function getRudicsGroup()
    {
        return $this->rudicsGroup;
    }
    /**
     * Set rudicsGroup value
     * @param string $rudicsGroup
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public function setRudicsGroup($rudicsGroup = null)
    {
        // validation for constraint: string
        if (!is_null($rudicsGroup) && !is_string($rudicsGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rudicsGroup)), __LINE__);
        }
        $this->rudicsGroup = $rudicsGroup;
        return $this;
    }
    /**
     * Get twoStageVoice value
     * @return \StructType\TwoStageImpl|null
     */
    public function getTwoStageVoice()
    {
        return $this->twoStageVoice;
    }
    /**
     * Set twoStageVoice value
     * @param \StructType\TwoStageImpl $twoStageVoice
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public function setTwoStageVoice(\StructType\TwoStageImpl $twoStageVoice = null)
    {
        $this->twoStageVoice = $twoStageVoice;
        return $this;
    }
    /**
     * Get twoStageData value
     * @return \StructType\TwoStageImpl|null
     */
    public function getTwoStageData()
    {
        return $this->twoStageData;
    }
    /**
     * Set twoStageData value
     * @param \StructType\TwoStageImpl $twoStageData
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public function setTwoStageData(\StructType\TwoStageImpl $twoStageData = null)
    {
        $this->twoStageData = $twoStageData;
        return $this;
    }
    /**
     * Get enableLocalNumber value
     * @return string|null
     */
    public function getEnableLocalNumber()
    {
        return $this->enableLocalNumber;
    }
    /**
     * Set enableLocalNumber value
     * @param string $enableLocalNumber
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public function setEnableLocalNumber($enableLocalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($enableLocalNumber) && !is_string($enableLocalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableLocalNumber)), __LINE__);
        }
        $this->enableLocalNumber = $enableLocalNumber;
        return $this;
    }
    /**
     * Get localCountry value
     * @return string|null
     */
    public function getLocalCountry()
    {
        return $this->localCountry;
    }
    /**
     * Set localCountry value
     * @param string $localCountry
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public function setLocalCountry($localCountry = null)
    {
        // validation for constraint: string
        if (!is_null($localCountry) && !is_string($localCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localCountry)), __LINE__);
        }
        $this->localCountry = $localCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephonyBulkPlanImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
