<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simLockResultImpl StructType
 * @subpackage Structs
 */
class SimLockResultImpl extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The simLockStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $simLockStatus;
    /**
     * Constructor method for simLockResultImpl
     * @uses SimLockResultImpl::setAccountNumber()
     * @uses SimLockResultImpl::setSimLockStatus()
     * @param string $accountNumber
     * @param string $simLockStatus
     */
    public function __construct($accountNumber = null, $simLockStatus = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setSimLockStatus($simLockStatus);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\SimLockResultImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get simLockStatus value
     * @return string|null
     */
    public function getSimLockStatus()
    {
        return $this->simLockStatus;
    }
    /**
     * Set simLockStatus value
     * @uses \EnumType\SimLockStatusEnum::valueIsValid()
     * @uses \EnumType\SimLockStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $simLockStatus
     * @return \StructType\SimLockResultImpl
     */
    public function setSimLockStatus($simLockStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SimLockStatusEnum::valueIsValid($simLockStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $simLockStatus, implode(', ', \EnumType\SimLockStatusEnum::getValidValues())), __LINE__);
        }
        $this->simLockStatus = $simLockStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimLockResultImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
