<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceCategories StructType
 * @subpackage Structs
 */
class ServiceCategories extends AbstractStructBase
{
    /**
     * The serviceCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $serviceCategory;
    /**
     * Constructor method for serviceCategories
     * @uses ServiceCategories::setServiceCategory()
     * @param string[] $serviceCategory
     */
    public function __construct(array $serviceCategory = array())
    {
        $this
            ->setServiceCategory($serviceCategory);
    }
    /**
     * Get serviceCategory value
     * @return string[]|null
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @uses \EnumType\ModelServiceCategoryEnum::valueIsValid()
     * @uses \EnumType\ModelServiceCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $serviceCategory
     * @return \StructType\ServiceCategories
     */
    public function setServiceCategory(array $serviceCategory = array())
    {
        $invalidValues = array();
        foreach ($serviceCategory as $serviceCategoriesServiceCategoryItem) {
            if (!\EnumType\ModelServiceCategoryEnum::valueIsValid($serviceCategoriesServiceCategoryItem)) {
                $invalidValues[] = var_export($serviceCategoriesServiceCategoryItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ModelServiceCategoryEnum::getValidValues())), __LINE__);
        }
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Add item to serviceCategory value
     * @uses \EnumType\ModelServiceCategoryEnum::valueIsValid()
     * @uses \EnumType\ModelServiceCategoryEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ServiceCategories
     */
    public function addToServiceCategory($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModelServiceCategoryEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ModelServiceCategoryEnum::getValidValues())), __LINE__);
        }
        $this->serviceCategory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceCategories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
