<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdSearchCriteriaImpl StructType
 * @subpackage Structs
 */
class SbdSearchCriteriaImpl extends AbsDeviceSearchCriteriaImpl
{
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $limit;
    /**
     * The orderBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderBy;
    /**
     * The searchType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchType;
    /**
     * The startRow
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $startRow;
    /**
     * The usageSearchType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usageSearchType;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for sbdSearchCriteriaImpl
     * @uses SbdSearchCriteriaImpl::setLimit()
     * @uses SbdSearchCriteriaImpl::setOrderBy()
     * @uses SbdSearchCriteriaImpl::setSearchType()
     * @uses SbdSearchCriteriaImpl::setStartRow()
     * @uses SbdSearchCriteriaImpl::setUsageSearchType()
     * @uses SbdSearchCriteriaImpl::setValue()
     * @param int $limit
     * @param string $orderBy
     * @param string $searchType
     * @param int $startRow
     * @param string $usageSearchType
     * @param string $value
     */
    public function __construct($limit = null, $orderBy = null, $searchType = null, $startRow = null, $usageSearchType = null, $value = null)
    {
        $this
            ->setLimit($limit)
            ->setOrderBy($orderBy)
            ->setSearchType($searchType)
            ->setStartRow($startRow)
            ->setUsageSearchType($usageSearchType)
            ->setValue($value);
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\SbdSearchCriteriaImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get orderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->orderBy;
    }
    /**
     * Set orderBy value
     * @uses \EnumType\SbdActivityOrderByTypeEnum::valueIsValid()
     * @uses \EnumType\SbdActivityOrderByTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderBy
     * @return \StructType\SbdSearchCriteriaImpl
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SbdActivityOrderByTypeEnum::valueIsValid($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $orderBy, implode(', ', \EnumType\SbdActivityOrderByTypeEnum::getValidValues())), __LINE__);
        }
        $this->orderBy = $orderBy;
        return $this;
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\SbdSearchTypeEnum::valueIsValid()
     * @uses \EnumType\SbdSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\SbdSearchCriteriaImpl
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SbdSearchTypeEnum::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \EnumType\SbdSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\SbdSearchCriteriaImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Get usageSearchType value
     * @return string|null
     */
    public function getUsageSearchType()
    {
        return $this->usageSearchType;
    }
    /**
     * Set usageSearchType value
     * @uses \EnumType\SbdUsageSearchTypeEnum::valueIsValid()
     * @uses \EnumType\SbdUsageSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usageSearchType
     * @return \StructType\SbdSearchCriteriaImpl
     */
    public function setUsageSearchType($usageSearchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SbdUsageSearchTypeEnum::valueIsValid($usageSearchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $usageSearchType, implode(', ', \EnumType\SbdUsageSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->usageSearchType = $usageSearchType;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\SbdSearchCriteriaImpl
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdSearchCriteriaImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
