<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdDetailsImpl StructType
 * @subpackage Structs
 */
class SbdDetailsImpl extends DeviceDetailsImpl
{
    /**
     * The totalNumberOfActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfActivities;
    /**
     * The activities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Activities
     */
    public $activities;
    /**
     * Constructor method for sbdDetailsImpl
     * @uses SbdDetailsImpl::setTotalNumberOfActivities()
     * @uses SbdDetailsImpl::setActivities()
     * @param int $totalNumberOfActivities
     * @param \StructType\Activities $activities
     */
    public function __construct($totalNumberOfActivities = null, \StructType\Activities $activities = null)
    {
        $this
            ->setTotalNumberOfActivities($totalNumberOfActivities)
            ->setActivities($activities);
    }
    /**
     * Get totalNumberOfActivities value
     * @return int|null
     */
    public function getTotalNumberOfActivities()
    {
        return $this->totalNumberOfActivities;
    }
    /**
     * Set totalNumberOfActivities value
     * @param int $totalNumberOfActivities
     * @return \StructType\SbdDetailsImpl
     */
    public function setTotalNumberOfActivities($totalNumberOfActivities = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfActivities) && !is_numeric($totalNumberOfActivities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfActivities)), __LINE__);
        }
        $this->totalNumberOfActivities = $totalNumberOfActivities;
        return $this;
    }
    /**
     * Get activities value
     * @return \StructType\Activities|null
     */
    public function getActivities()
    {
        return $this->activities;
    }
    /**
     * Set activities value
     * @param \StructType\Activities $activities
     * @return \StructType\SbdDetailsImpl
     */
    public function setActivities(\StructType\Activities $activities = null)
    {
        $this->activities = $activities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdDetailsImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
