<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resources StructType
 * @subpackage Structs
 */
class Resources extends AbstractStructBase
{
    /**
     * The resource
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MoipQueueReportEntryImpl[]
     */
    public $resource;
    /**
     * Constructor method for resources
     * @uses Resources::setResource()
     * @param \StructType\MoipQueueReportEntryImpl[] $resource
     */
    public function __construct(array $resource = array())
    {
        $this
            ->setResource($resource);
    }
    /**
     * Get resource value
     * @return \StructType\MoipQueueReportEntryImpl[]|null
     */
    public function getResource()
    {
        return $this->resource;
    }
    /**
     * Set resource value
     * @throws \InvalidArgumentException
     * @param \StructType\MoipQueueReportEntryImpl[] $resource
     * @return \StructType\Resources
     */
    public function setResource(array $resource = array())
    {
        foreach ($resource as $resourcesResourceItem) {
            // validation for constraint: itemType
            if (!$resourcesResourceItem instanceof \StructType\MoipQueueReportEntryImpl) {
                throw new \InvalidArgumentException(sprintf('The resource property can only contain items of \StructType\MoipQueueReportEntryImpl, "%s" given', is_object($resourcesResourceItem) ? get_class($resourcesResourceItem) : gettype($resourcesResourceItem)), __LINE__);
            }
        }
        $this->resource = $resource;
        return $this;
    }
    /**
     * Add item to resource value
     * @throws \InvalidArgumentException
     * @param \StructType\MoipQueueReportEntryImpl $item
     * @return \StructType\Resources
     */
    public function addToResource(\StructType\MoipQueueReportEntryImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MoipQueueReportEntryImpl) {
            throw new \InvalidArgumentException(sprintf('The resource property can only contain items of \StructType\MoipQueueReportEntryImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->resource[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Resources
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
