<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for requiredGroupImpl StructType
 * @subpackage Structs
 */
class RequiredGroupImpl extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The requiredNum
     * @var int
     */
    public $requiredNum;
    /**
     * Constructor method for requiredGroupImpl
     * @uses RequiredGroupImpl::setName()
     * @uses RequiredGroupImpl::setRequiredNum()
     * @param string $name
     * @param int $requiredNum
     */
    public function __construct($name = null, $requiredNum = null)
    {
        $this
            ->setName($name)
            ->setRequiredNum($requiredNum);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RequiredGroupImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get requiredNum value
     * @return int|null
     */
    public function getRequiredNum()
    {
        return $this->requiredNum;
    }
    /**
     * Set requiredNum value
     * @param int $requiredNum
     * @return \StructType\RequiredGroupImpl
     */
    public function setRequiredNum($requiredNum = null)
    {
        // validation for constraint: int
        if (!is_null($requiredNum) && !is_numeric($requiredNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($requiredNum)), __LINE__);
        }
        $this->requiredNum = $requiredNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequiredGroupImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
