<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pttDeviceBulkPlanImpl StructType
 * @subpackage Structs
 */
class PttDeviceBulkPlanImpl extends PttDeviceBulkBaseImpl
{
    /**
     * The submarketId
     * @var string
     */
    public $submarketId;
    /**
     * The servicePlanOptions
     * @var \StructType\ServicePlanOptions
     */
    public $servicePlanOptions;
    /**
     * Constructor method for pttDeviceBulkPlanImpl
     * @uses PttDeviceBulkPlanImpl::setSubmarketId()
     * @uses PttDeviceBulkPlanImpl::setServicePlanOptions()
     * @param string $submarketId
     * @param \StructType\ServicePlanOptions $servicePlanOptions
     */
    public function __construct($submarketId = null, \StructType\ServicePlanOptions $servicePlanOptions = null)
    {
        $this
            ->setSubmarketId($submarketId)
            ->setServicePlanOptions($servicePlanOptions);
    }
    /**
     * Get submarketId value
     * @return string|null
     */
    public function getSubmarketId()
    {
        return $this->submarketId;
    }
    /**
     * Set submarketId value
     * @param string $submarketId
     * @return \StructType\PttDeviceBulkPlanImpl
     */
    public function setSubmarketId($submarketId = null)
    {
        // validation for constraint: string
        if (!is_null($submarketId) && !is_string($submarketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketId)), __LINE__);
        }
        $this->submarketId = $submarketId;
        return $this;
    }
    /**
     * Get servicePlanOptions value
     * @return \StructType\ServicePlanOptions|null
     */
    public function getServicePlanOptions()
    {
        return $this->servicePlanOptions;
    }
    /**
     * Set servicePlanOptions value
     * @param \StructType\ServicePlanOptions $servicePlanOptions
     * @return \StructType\PttDeviceBulkPlanImpl
     */
    public function setServicePlanOptions(\StructType\ServicePlanOptions $servicePlanOptions = null)
    {
        $this->servicePlanOptions = $servicePlanOptions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PttDeviceBulkPlanImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
