<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prepaidCallHistoryEntryImpl StructType
 * @subpackage Structs
 */
class PrepaidCallHistoryEntryImpl extends AbstractStructBase
{
    /**
     * The serviceProviderAccountNumber
     * @var string
     */
    public $serviceProviderAccountNumber;
    /**
     * The msisdn
     * @var string
     */
    public $msisdn;
    /**
     * The serialNumber
     * @var string
     */
    public $serialNumber;
    /**
     * The callDestinationNumber
     * @var string
     */
    public $callDestinationNumber;
    /**
     * The startCallDate
     * @var string
     */
    public $startCallDate;
    /**
     * The endCallDate
     * @var string
     */
    public $endCallDate;
    /**
     * The duration
     * @var int
     */
    public $duration;
    /**
     * The state
     * @var string
     */
    public $state;
    /**
     * The balance
     * @var string
     */
    public $balance;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * Constructor method for prepaidCallHistoryEntryImpl
     * @uses PrepaidCallHistoryEntryImpl::setServiceProviderAccountNumber()
     * @uses PrepaidCallHistoryEntryImpl::setMsisdn()
     * @uses PrepaidCallHistoryEntryImpl::setSerialNumber()
     * @uses PrepaidCallHistoryEntryImpl::setCallDestinationNumber()
     * @uses PrepaidCallHistoryEntryImpl::setStartCallDate()
     * @uses PrepaidCallHistoryEntryImpl::setEndCallDate()
     * @uses PrepaidCallHistoryEntryImpl::setDuration()
     * @uses PrepaidCallHistoryEntryImpl::setState()
     * @uses PrepaidCallHistoryEntryImpl::setBalance()
     * @uses PrepaidCallHistoryEntryImpl::setServiceType()
     * @param string $serviceProviderAccountNumber
     * @param string $msisdn
     * @param string $serialNumber
     * @param string $callDestinationNumber
     * @param string $startCallDate
     * @param string $endCallDate
     * @param int $duration
     * @param string $state
     * @param string $balance
     * @param string $serviceType
     */
    public function __construct($serviceProviderAccountNumber = null, $msisdn = null, $serialNumber = null, $callDestinationNumber = null, $startCallDate = null, $endCallDate = null, $duration = null, $state = null, $balance = null, $serviceType = null)
    {
        $this
            ->setServiceProviderAccountNumber($serviceProviderAccountNumber)
            ->setMsisdn($msisdn)
            ->setSerialNumber($serialNumber)
            ->setCallDestinationNumber($callDestinationNumber)
            ->setStartCallDate($startCallDate)
            ->setEndCallDate($endCallDate)
            ->setDuration($duration)
            ->setState($state)
            ->setBalance($balance)
            ->setServiceType($serviceType);
    }
    /**
     * Get serviceProviderAccountNumber value
     * @return string|null
     */
    public function getServiceProviderAccountNumber()
    {
        return $this->serviceProviderAccountNumber;
    }
    /**
     * Set serviceProviderAccountNumber value
     * @param string $serviceProviderAccountNumber
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setServiceProviderAccountNumber($serviceProviderAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderAccountNumber) && !is_string($serviceProviderAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderAccountNumber)), __LINE__);
        }
        $this->serviceProviderAccountNumber = $serviceProviderAccountNumber;
        return $this;
    }
    /**
     * Get msisdn value
     * @return string|null
     */
    public function getMsisdn()
    {
        return $this->msisdn;
    }
    /**
     * Set msisdn value
     * @param string $msisdn
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msisdn)), __LINE__);
        }
        $this->msisdn = $msisdn;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get callDestinationNumber value
     * @return string|null
     */
    public function getCallDestinationNumber()
    {
        return $this->callDestinationNumber;
    }
    /**
     * Set callDestinationNumber value
     * @param string $callDestinationNumber
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setCallDestinationNumber($callDestinationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($callDestinationNumber) && !is_string($callDestinationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callDestinationNumber)), __LINE__);
        }
        $this->callDestinationNumber = $callDestinationNumber;
        return $this;
    }
    /**
     * Get startCallDate value
     * @return string|null
     */
    public function getStartCallDate()
    {
        return $this->startCallDate;
    }
    /**
     * Set startCallDate value
     * @param string $startCallDate
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setStartCallDate($startCallDate = null)
    {
        // validation for constraint: string
        if (!is_null($startCallDate) && !is_string($startCallDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startCallDate)), __LINE__);
        }
        $this->startCallDate = $startCallDate;
        return $this;
    }
    /**
     * Get endCallDate value
     * @return string|null
     */
    public function getEndCallDate()
    {
        return $this->endCallDate;
    }
    /**
     * Set endCallDate value
     * @param string $endCallDate
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setEndCallDate($endCallDate = null)
    {
        // validation for constraint: string
        if (!is_null($endCallDate) && !is_string($endCallDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endCallDate)), __LINE__);
        }
        $this->endCallDate = $endCallDate;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get balance value
     * @return string|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param string $balance
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepaidCallHistoryEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
