<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for permittedServices StructType
 * @subpackage Structs
 */
class PermittedServices extends AbstractStructBase
{
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $service;
    /**
     * Constructor method for permittedServices
     * @uses PermittedServices::setService()
     * @param string[] $service
     */
    public function __construct(array $service = array())
    {
        $this
            ->setService($service);
    }
    /**
     * Get service value
     * @return string[]|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \EnumType\PurchaseConditionEnum::valueIsValid()
     * @uses \EnumType\PurchaseConditionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $service
     * @return \StructType\PermittedServices
     */
    public function setService(array $service = array())
    {
        $invalidValues = array();
        foreach ($service as $permittedServicesServiceItem) {
            if (!\EnumType\PurchaseConditionEnum::valueIsValid($permittedServicesServiceItem)) {
                $invalidValues[] = var_export($permittedServicesServiceItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\PurchaseConditionEnum::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Add item to service value
     * @uses \EnumType\PurchaseConditionEnum::valueIsValid()
     * @uses \EnumType\PurchaseConditionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PermittedServices
     */
    public function addToService($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PurchaseConditionEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\PurchaseConditionEnum::getValidValues())), __LINE__);
        }
        $this->service[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PermittedServices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
